/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.BinaryLogicAbstract;
import org.geotools.filter.Filter;
import org.geotools.filter.LogicFilter;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;

public abstract class LogicFilterImpl
extends BinaryLogicAbstract
implements LogicFilter {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");

    protected LogicFilterImpl(FilterFactory filterFactory) {
        this(filterFactory, new ArrayList());
    }

    protected LogicFilterImpl(FilterFactory filterFactory, List list) {
        super(filterFactory, list);
    }

    @Override
    public Filter or(org.opengis.filter.Filter filter) {
        if (this.filterType == 1) {
            if (filter instanceof Or) {
                Or or = (Or)filter;
                this.children.addAll(or.getChildren());
            } else {
                this.children.add(filter);
            }
            return this;
        }
        return super.or(filter);
    }

    @Override
    public Filter and(org.opengis.filter.Filter filter) {
        if (this.filterType == 2) {
            if (filter instanceof And) {
                And and = (And)filter;
                this.children.addAll(and.getChildren());
            } else {
                this.children.add(filter);
            }
            return this;
        }
        return super.and(filter);
    }

    @Override
    public Filter not() {
        if (this.filterType == 3) {
            return (Filter)this.children.get(0);
        }
        return super.not();
    }

    List getSubFilters() {
        return this.children;
    }

    public String toString() {
        String string = "[";
        String string2 = "";
        Iterator iterator = this.children.iterator();
        if (this.filterType == 1) {
            string2 = " OR ";
        } else if (this.filterType == 2) {
            string2 = " AND ";
        } else if (this.filterType == 3) {
            return "[ NOT " + iterator.next().toString() + " ]";
        }
        while (iterator.hasNext()) {
            string = string + iterator.next().toString();
            if (!iterator.hasNext()) continue;
            string = string + string2;
        }
        return string + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            LogicFilterImpl logicFilterImpl = (LogicFilterImpl)object;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("filter type match:" + (logicFilterImpl.getFilterType() == this.filterType));
                LOGGER.finest("same size:" + (logicFilterImpl.getSubFilters().size() == this.children.size()) + "; inner size: " + logicFilterImpl.getSubFilters().size() + "; outer size: " + this.children.size());
                LOGGER.finest("contains:" + logicFilterImpl.getSubFilters().containsAll(this.children));
            }
            return logicFilterImpl.getFilterType() == this.filterType && logicFilterImpl.getSubFilters().size() == this.children.size() && logicFilterImpl.getSubFilters().containsAll(this.children);
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.filterType;
        n = 37 * n + this.children.hashCode();
        return n;
    }

    @Override
    public abstract Object accept(FilterVisitor var1, Object var2);
}

