/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.resources.Classes;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

public class ComplexTypeImpl
extends AttributeTypeImpl
implements ComplexType {
    private final Collection<PropertyDescriptor> properties;
    private final Map<Name, PropertyDescriptor> propertyMap;

    public ComplexTypeImpl(Name name, Collection<PropertyDescriptor> collection, boolean bl, boolean bl2, List<Filter> list, AttributeType attributeType, InternationalString internationalString) {
        super(name, Collection.class, bl, bl2, list, attributeType, internationalString);
        Map<Name, PropertyDescriptor> map;
        List list2;
        if (collection == null) {
            list2 = Collections.emptyList();
            map = Collections.emptyMap();
        } else {
            list2 = new ArrayList<PropertyDescriptor>(collection);
            map = new HashMap();
            for (PropertyDescriptor propertyDescriptor : collection) {
                if (propertyDescriptor == null) {
                    throw new NullPointerException("PropertyDescriptor is null - did you request a property that does not exist?");
                }
                map.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        this.properties = Collections.unmodifiableList(list2);
        this.propertyMap = Collections.unmodifiableMap(map);
    }

    @Override
    public Class<Collection<Property>> getBinding() {
        return super.getBinding();
    }

    @Override
    public Collection<PropertyDescriptor> getDescriptors() {
        return this.properties;
    }

    @Override
    public PropertyDescriptor getDescriptor(Name name) {
        return this.propertyMap.get(name);
    }

    @Override
    public PropertyDescriptor getDescriptor(String string) {
        PropertyDescriptor propertyDescriptor = this.getDescriptor(new NameImpl(string));
        if (propertyDescriptor == null && (propertyDescriptor = this.getDescriptor(new NameImpl(this.getName().getNamespaceURI(), string))) == null) {
            for (PropertyDescriptor propertyDescriptor2 : this.properties) {
                if (!propertyDescriptor2.getName().getLocalPart().equals(string)) continue;
                return propertyDescriptor2;
            }
        }
        return propertyDescriptor;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ComplexTypeImpl complexTypeImpl = (ComplexTypeImpl)object;
        return this.properties.equals(complexTypeImpl.properties);
    }

    @Override
    public int hashCode() {
        return 59 * super.hashCode() + this.properties.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(Classes.getShortClassName(this));
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        if (this.isAbstract()) {
            stringBuffer.append(" abstract");
        }
        if (this.isIdentified()) {
            stringBuffer.append(" identified");
        }
        if (this.superType != null) {
            stringBuffer.append(" extends ");
            stringBuffer.append(this.superType.getName().getLocalPart());
        }
        if (List.class.isAssignableFrom(this.binding)) {
            stringBuffer.append("[");
        } else {
            stringBuffer.append("(");
        }
        boolean bl = true;
        for (PropertyDescriptor object : this.getDescriptors()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(object.getName().getLocalPart());
            stringBuffer.append(":");
            stringBuffer.append(object.getType().getName().getLocalPart());
        }
        if (List.class.isAssignableFrom(this.binding)) {
            stringBuffer.append("]");
        } else {
            stringBuffer.append(")");
        }
        if (this.description != null) {
            stringBuffer.append("\n\tdescription=");
            stringBuffer.append(this.description);
        }
        if (this.restrictions != null && !this.restrictions.isEmpty()) {
            stringBuffer.append("\nrestrictions=");
            bl = true;
            for (Filter filter : this.restrictions) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(filter);
            }
        }
        return stringBuffer.toString();
    }
}

