/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.io.Serializable;
import org.geotools.util.Utilities;
import org.opengis.feature.type.Name;

public class NameImpl
implements Name,
Serializable,
Comparable<NameImpl> {
    private static final long serialVersionUID = 4564070184645559899L;
    protected String namespace;
    protected String local;
    private String separator;

    public NameImpl(String string) {
        this(null, string);
    }

    public NameImpl(String string, String string2) {
        this(string, ":", string2);
    }

    public NameImpl(String string, String string2, String string3) {
        this.namespace = string;
        this.separator = string2;
        this.local = string3;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespace;
    }

    @Override
    public String getLocalPart() {
        return this.local;
    }

    @Override
    public String getURI() {
        if (this.namespace == null && this.local == null) {
            return null;
        }
        if (this.namespace == null) {
            return this.local;
        }
        if (this.local == null) {
            return this.namespace;
        }
        return new StringBuffer(this.namespace).append(this.separator).append(this.local).toString();
    }

    @Override
    public int hashCode() {
        return (this.namespace == null ? 0 : this.namespace.hashCode()) + 37 * (this.local == null ? 0 : this.local.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Name) {
            NameImpl nameImpl = (NameImpl)object;
            if (!Utilities.equals(this.namespace, nameImpl.getNamespaceURI())) {
                return false;
            }
            return Utilities.equals(this.local, nameImpl.getLocalPart());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getURI();
    }

    @Override
    public int compareTo(NameImpl nameImpl) {
        if (nameImpl == null) {
            return 1;
        }
        return this.getURI().compareTo(nameImpl.getURI());
    }
}

