/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.data.ALLQuery;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Query {
    public static final URI NO_NAMESPACE = null;
    public static final int DEFAULT_MAX = Integer.MAX_VALUE;
    public static final Query ALL = new ALLQuery();
    public static final String[] NO_NAMES = new String[0];
    public static final String[] ALL_NAMES = null;
    public static final List<PropertyName> ALL_PROPERTIES = null;
    protected List<PropertyName> properties;
    protected int maxFeatures = Integer.MAX_VALUE;
    protected Integer startIndex = null;
    protected Filter filter = Filter.INCLUDE;
    protected String typeName;
    protected URI namespace = NO_NAMESPACE;
    protected String handle;
    protected CoordinateReferenceSystem coordinateSystem;
    protected CoordinateReferenceSystem coordinateSystemReproject;
    protected SortBy[] sortBy;
    protected String version;
    protected Hints hints;

    public Query() {
    }

    public Query(String string) {
        this(string, Filter.INCLUDE);
    }

    public Query(String string, Filter filter) {
        this(string, filter, ALL_NAMES);
    }

    public Query(String string, Filter filter, String[] stringArray) {
        this(string, null, filter, Integer.MAX_VALUE, stringArray, null);
    }

    public Query(String string, Filter filter, int n, String[] stringArray, String string2) {
        this(string, null, filter, n, stringArray, string2);
    }

    public Query(String string, URI uRI, Filter filter, int n, String[] stringArray, String string2) {
        this.typeName = string;
        this.filter = filter;
        this.namespace = uRI;
        this.maxFeatures = n;
        this.handle = string2;
        this.setPropertyNames(stringArray);
    }

    public Query(String string, URI uRI, Filter filter, int n, List<PropertyName> list, String string2) {
        this.typeName = string;
        this.filter = filter;
        this.namespace = uRI;
        this.maxFeatures = n;
        this.handle = string2;
        this.properties = list == null ? null : new ArrayList<PropertyName>(list);
    }

    public Query(Query query) {
        this(query.getTypeName(), query.getNamespace(), query.getFilter(), query.getMaxFeatures(), query.getProperties(), query.getHandle());
        this.sortBy = query.getSortBy();
        this.coordinateSystem = query.getCoordinateSystem();
        this.coordinateSystemReproject = query.getCoordinateSystemReproject();
        this.version = query.getVersion();
        this.hints = query.getHints();
        this.startIndex = query.getStartIndex();
    }

    public String[] getPropertyNames() {
        if (this.properties == null) {
            return null;
        }
        String[] stringArray = new String[this.properties.size()];
        for (int i = 0; i < this.properties.size(); ++i) {
            String string;
            PropertyName propertyName = this.properties.get(i);
            if (propertyName == null) continue;
            stringArray[i] = string = propertyName.getPropertyName();
        }
        return stringArray;
    }

    public void setPropertyNames(String[] stringArray) {
        if (stringArray == null) {
            this.properties = ALL_PROPERTIES;
            return;
        }
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        this.properties = new ArrayList<PropertyName>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            this.properties.add(filterFactory.property(string));
        }
    }

    public List<PropertyName> getProperties() {
        if (this.properties == ALL_PROPERTIES) {
            return ALL_PROPERTIES;
        }
        return Collections.unmodifiableList(this.properties);
    }

    public void setPropertyNames(List<String> list) {
        if (list == null) {
            this.properties = ALL_PROPERTIES;
            return;
        }
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        this.properties = new ArrayList<PropertyName>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string == null) continue;
            this.properties.add(filterFactory.property(string));
        }
    }

    public boolean retrieveAllProperties() {
        return this.properties == null;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public boolean isMaxFeaturesUnlimited() {
        return this.maxFeatures < 0 || this.maxFeatures == Integer.MAX_VALUE;
    }

    public void setMaxFeatures(int n) {
        this.maxFeatures = n;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer n) {
        if (n != null && n < 0) {
            throw new IllegalArgumentException("startIndex shall be a positive integer: " + n);
        }
        this.startIndex = n;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public void setNamespace(URI uRI) {
        this.namespace = uRI;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String string) {
        this.handle = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public CoordinateReferenceSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateSystem = coordinateReferenceSystem;
    }

    public CoordinateReferenceSystem getCoordinateSystemReproject() {
        return this.coordinateSystemReproject;
    }

    public void setCoordinateSystemReproject(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateSystemReproject = coordinateReferenceSystem;
    }

    public SortBy[] getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortBy[] sortByArray) {
        this.sortBy = sortByArray;
    }

    public Hints getHints() {
        if (this.hints == null) {
            this.hints = new Hints(Collections.EMPTY_MAP);
        }
        return this.hints;
    }

    public void setHints(Hints hints) {
        this.hints = hints;
    }

    public int hashCode() {
        String[] stringArray = this.getPropertyNames();
        return (stringArray == null ? -1 : (stringArray.length == 0 ? 0 : stringArray.length | stringArray[0].hashCode())) | this.getMaxFeatures() | (this.getFilter() == null ? 0 : this.getFilter().hashCode()) | (this.getTypeName() == null ? 0 : this.getTypeName().hashCode()) | (this.getVersion() == null ? 0 : this.getVersion().hashCode()) | (this.getCoordinateSystem() == null ? 0 : this.getCoordinateSystem().hashCode()) | (this.getCoordinateSystemReproject() == null ? 0 : this.getCoordinateSystemReproject().hashCode()) | this.getStartIndex();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Query)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Query query = (Query)object;
        return Arrays.equals(this.getPropertyNames(), query.getPropertyNames()) && this.retrieveAllProperties() == query.retrieveAllProperties() && this.getMaxFeatures() == query.getMaxFeatures() && (this.getFilter() == null ? query.getFilter() == null : this.getFilter().equals(query.getFilter())) && (this.getTypeName() == null ? query.getTypeName() == null : this.getTypeName().equals(query.getTypeName())) && (this.getVersion() == null ? query.getVersion() == null : this.getVersion().equals(query.getVersion())) && (this.getCoordinateSystem() == null ? query.getCoordinateSystem() == null : this.getCoordinateSystem().equals(query.getCoordinateSystem())) && (this.getCoordinateSystemReproject() == null ? query.getCoordinateSystemReproject() == null : this.getCoordinateSystemReproject().equals(query.getCoordinateSystemReproject())) && this.getStartIndex() == query.getStartIndex() && (this.getHints() == null ? query.getHints() == null : this.getHints().equals(query.getHints()));
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Query:");
        if (this.handle != null) {
            stringBuffer.append(" [" + this.handle + "]");
        }
        stringBuffer.append("\n   feature type: " + this.typeName);
        if (this.filter != null) {
            stringBuffer.append("\n   filter: " + this.filter.toString());
        }
        stringBuffer.append("\n   [properties: ");
        if (this.properties == null || this.properties.size() == 0) {
            stringBuffer.append(" ALL ]");
        } else {
            for (n = 0; n < this.properties.size(); ++n) {
                stringBuffer.append(this.properties.get(n));
                if (n >= this.properties.size() - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
        }
        if (this.sortBy != null && this.sortBy.length > 0) {
            stringBuffer.append("\n   [sort by: ");
            for (n = 0; n < this.sortBy.length; ++n) {
                stringBuffer.append(this.sortBy[n].getPropertyName().getPropertyName());
                stringBuffer.append(" ");
                stringBuffer.append(this.sortBy[n].getSortOrder().name());
                if (n >= this.sortBy.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

