/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class DefaultFeatureResults
extends DataFeatureCollection {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.data");
    protected Query query;
    protected SimpleFeatureSource featureSource;
    protected MathTransform transform;

    public DefaultFeatureResults(SimpleFeatureSource simpleFeatureSource, Query query) throws IOException {
        super(null, DefaultFeatureResults.getSchemaInternal(simpleFeatureSource, query));
        this.featureSource = simpleFeatureSource;
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)simpleFeatureSource.getSchema();
        String string = simpleFeatureType.getTypeName();
        if (string.equals(query.getTypeName())) {
            this.query = query;
        } else {
            this.query = new DefaultQuery(query);
            ((DefaultQuery)this.query).setTypeName(string);
        }
        if (simpleFeatureType.getGeometryDescriptor() == null) {
            return;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        if (query.getCoordinateSystemReproject() != null) {
            coordinateReferenceSystem = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            coordinateReferenceSystem = query.getCoordinateSystem();
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = simpleFeatureType.getGeometryDescriptor().getCoordinateReferenceSystem();
        if (query.getCoordinateSystem() != null) {
            coordinateReferenceSystem2 = query.getCoordinateSystem();
        }
        if (coordinateReferenceSystem != null && coordinateReferenceSystem != coordinateReferenceSystem2) {
            try {
                this.transform = CRS.findMathTransform(coordinateReferenceSystem2, coordinateReferenceSystem, true);
            }
            catch (FactoryException factoryException) {
                throw (IOException)new IOException("Could not reproject data to " + coordinateReferenceSystem).initCause(factoryException);
            }
        }
    }

    static SimpleFeatureType getSchemaInternal(SimpleFeatureSource simpleFeatureSource, Query query) {
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)simpleFeatureSource.getSchema();
        SimpleFeatureType simpleFeatureType2 = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        if (query.getCoordinateSystemReproject() != null) {
            coordinateReferenceSystem = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            coordinateReferenceSystem = query.getCoordinateSystem();
        }
        try {
            simpleFeatureType2 = coordinateReferenceSystem == null ? (query.retrieveAllProperties() ? (SimpleFeatureType)simpleFeatureSource.getSchema() : DataUtilities.createSubType((SimpleFeatureType)simpleFeatureSource.getSchema(), query.getPropertyNames())) : DataUtilities.createSubType(simpleFeatureType, query.getPropertyNames(), coordinateReferenceSystem, query.getTypeName(), null);
        }
        catch (SchemaException schemaException) {
            LOGGER.log(Level.WARNING, "Could not change projection to " + coordinateReferenceSystem, schemaException);
        }
        return simpleFeatureType2;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return super.getSchema();
    }

    protected Transaction getTransaction() {
        if (this.featureSource instanceof FeatureStore) {
            SimpleFeatureStore simpleFeatureStore = (SimpleFeatureStore)this.featureSource;
            return simpleFeatureStore.getTransaction();
        }
        return Transaction.AUTO_COMMIT;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        ReprojectFeatureReader reprojectFeatureReader = ((DataStore)this.featureSource.getDataStore()).getFeatureReader(this.query, this.getTransaction());
        int n = this.query.getMaxFeatures();
        if (n != Integer.MAX_VALUE) {
            reprojectFeatureReader = new MaxFeatureReader<SimpleFeatureType, SimpleFeature>(reprojectFeatureReader, n);
        }
        if (this.transform != null) {
            reprojectFeatureReader = new ReprojectFeatureReader(reprojectFeatureReader, this.getSchema(), this.transform);
        }
        return reprojectFeatureReader;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> boundsReader() throws IOException {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)this.featureSource.getSchema();
        for (int i = 0; i < simpleFeatureType.getAttributeCount(); ++i) {
            object = simpleFeatureType.getDescriptor(i);
            if (!(object instanceof GeometryDescriptorImpl)) continue;
            arrayList.add(object.getLocalName());
        }
        DefaultQuery defaultQuery = new DefaultQuery(this.query);
        defaultQuery.setPropertyNames(arrayList);
        object = ((DataStore)this.featureSource.getDataStore()).getFeatureReader(defaultQuery, this.getTransaction());
        int n = this.query.getMaxFeatures();
        if (n == Integer.MAX_VALUE) {
            return object;
        }
        return new MaxFeatureReader<SimpleFeatureType, SimpleFeature>((FeatureReader<SimpleFeatureType, SimpleFeature>)object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope referencedEnvelope;
        try {
            referencedEnvelope = this.featureSource.getBounds(this.query);
        }
        catch (IOException iOException) {
            referencedEnvelope = new ReferencedEnvelope((CoordinateReferenceSystem)null);
        }
        if (referencedEnvelope == null) {
            try {
                referencedEnvelope = new ReferencedEnvelope();
                FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.boundsReader();
                try {
                    while (featureReader.hasNext()) {
                        SimpleFeature simpleFeature = featureReader.next();
                        referencedEnvelope.include(simpleFeature.getBounds());
                    }
                }
                finally {
                    featureReader.close();
                }
            }
            catch (IllegalAttributeException illegalAttributeException) {
                referencedEnvelope = new ReferencedEnvelope();
            }
            catch (IOException iOException) {
                referencedEnvelope = new ReferencedEnvelope();
            }
        }
        return referencedEnvelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() throws IOException {
        int n = this.featureSource.getCount(this.query);
        if (n != -1) {
            int n2 = this.query.getMaxFeatures();
            return n < n2 ? n : n2;
        }
        try {
            n = 0;
            FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.reader();
            try {
                while (featureReader.hasNext()) {
                    featureReader.next();
                    ++n;
                }
            }
            finally {
                featureReader.close();
            }
            return n;
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new DataSourceException("Could not read feature ", illegalAttributeException);
        }
    }
}

