/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.VecMathI18N;
import javax.vecmath.VecMathUtil;

public class Matrix4d
implements Serializable,
Cloneable {
    static final long serialVersionUID = 8223903484171633710L;
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Matrix4d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
    }

    public Matrix4d() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 0.0;
    }

    public String toString() {
        return this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + "\n" + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + "\n" + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + "\n" + this.m30 + ", " + this.m31 + ", " + this.m32 + ", " + this.m33 + "\n";
    }

    public final void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void setElement(int n, int n2, double d) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = d;
                        break block0;
                    }
                    case 1: {
                        this.m01 = d;
                        break block0;
                    }
                    case 2: {
                        this.m02 = d;
                        break block0;
                    }
                    case 3: {
                        this.m03 = d;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = d;
                        break block0;
                    }
                    case 1: {
                        this.m11 = d;
                        break block0;
                    }
                    case 2: {
                        this.m12 = d;
                        break block0;
                    }
                    case 3: {
                        this.m13 = d;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.m20 = d;
                        break block0;
                    }
                    case 1: {
                        this.m21 = d;
                        break block0;
                    }
                    case 2: {
                        this.m22 = d;
                        break block0;
                    }
                    case 3: {
                        this.m23 = d;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        this.m30 = d;
                        break block0;
                    }
                    case 1: {
                        this.m31 = d;
                        break block0;
                    }
                    case 2: {
                        this.m32 = d;
                        break block0;
                    }
                    case 3: {
                        this.m33 = d;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
        }
    }

    public final double getElement(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
                break;
            }
        }
        throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d1"));
    }

    public final void transpose() {
        double d = this.m10;
        this.m10 = this.m01;
        this.m01 = d;
        d = this.m20;
        this.m20 = this.m02;
        this.m02 = d;
        d = this.m30;
        this.m30 = this.m03;
        this.m03 = d;
        d = this.m21;
        this.m21 = this.m12;
        this.m12 = d;
        d = this.m31;
        this.m31 = this.m13;
        this.m13 = d;
        d = this.m32;
        this.m32 = this.m23;
        this.m23 = d;
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    final void invertGeneral(Matrix4d matrix4d) {
        double[] dArray = new double[16];
        int[] nArray = new int[4];
        double[] dArray2 = new double[]{matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33};
        if (!Matrix4d.luDecomposition(dArray2, nArray)) {
            throw new SingularMatrixException(VecMathI18N.getString("Matrix4d10"));
        }
        for (int i = 0; i < 16; ++i) {
            dArray[i] = 0.0;
        }
        dArray[0] = 1.0;
        dArray[5] = 1.0;
        dArray[10] = 1.0;
        dArray[15] = 1.0;
        Matrix4d.luBacksubstitution(dArray2, nArray, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m03 = dArray[3];
        this.m10 = dArray[4];
        this.m11 = dArray[5];
        this.m12 = dArray[6];
        this.m13 = dArray[7];
        this.m20 = dArray[8];
        this.m21 = dArray[9];
        this.m22 = dArray[10];
        this.m23 = dArray[11];
        this.m30 = dArray[12];
        this.m31 = dArray[13];
        this.m32 = dArray[14];
        this.m33 = dArray[15];
    }

    static boolean luDecomposition(double[] dArray, int[] nArray) {
        int n;
        double[] dArray2 = new double[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        while (n4-- != 0) {
            double d = 0.0;
            n = 4;
            while (n-- != 0) {
                double d2 = dArray[n2++];
                if (!((d2 = Math.abs(d2)) > d)) continue;
                d = d2;
            }
            if (d == 0.0) {
                return false;
            }
            dArray2[n3++] = 1.0 / d;
        }
        n = 0;
        for (n4 = 0; n4 < 4; ++n4) {
            double d;
            int n5;
            int n6;
            int n7;
            double d3;
            int n8;
            for (n2 = 0; n2 < n4; ++n2) {
                n8 = n + 4 * n2 + n4;
                d3 = dArray[n8];
                int n9 = n2;
                int n10 = n + 4 * n2;
                n7 = n + n4;
                while (n9-- != 0) {
                    d3 -= dArray[n10] * dArray[n7];
                    ++n10;
                    n7 += 4;
                }
                dArray[n8] = d3;
            }
            double d4 = 0.0;
            n3 = -1;
            for (n2 = n4; n2 < 4; ++n2) {
                double d5;
                n8 = n + 4 * n2 + n4;
                d3 = dArray[n8];
                n6 = n4;
                n5 = n + 4 * n2;
                n7 = n + n4;
                while (n6-- != 0) {
                    d3 -= dArray[n5] * dArray[n7];
                    ++n5;
                    n7 += 4;
                }
                dArray[n8] = d3;
                d = dArray2[n2] * Math.abs(d3);
                if (!(d5 >= d4)) continue;
                d4 = d;
                n3 = n2;
            }
            if (n3 < 0) {
                throw new RuntimeException(VecMathI18N.getString("Matrix4d11"));
            }
            if (n4 != n3) {
                n6 = 4;
                n5 = n + 4 * n3;
                n7 = n + 4 * n4;
                while (n6-- != 0) {
                    d = dArray[n5];
                    dArray[n5++] = dArray[n7];
                    dArray[n7++] = d;
                }
                dArray2[n3] = dArray2[n4];
            }
            nArray[n4] = n3;
            if (dArray[n + 4 * n4 + n4] == 0.0) {
                return false;
            }
            if (n4 == 3) continue;
            d = 1.0 / dArray[n + 4 * n4 + n4];
            n8 = n + 4 * (n4 + 1) + n4;
            n2 = 3 - n4;
            while (n2-- != 0) {
                int n11 = n8;
                dArray[n11] = dArray[n11] * d;
                n8 += 4;
            }
        }
        return true;
    }

    static void luBacksubstitution(double[] dArray, int[] nArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2;
            int n3 = i;
            int n4 = -1;
            for (int j = 0; j < 4; ++j) {
                int n5 = nArray[n + j];
                double d = dArray2[n3 + 4 * n5];
                dArray2[n3 + 4 * n5] = dArray2[n3 + 4 * j];
                if (n4 >= 0) {
                    n2 = j * 4;
                    for (int k = n4; k <= j - 1; ++k) {
                        d -= dArray[n2 + k] * dArray2[n3 + 4 * k];
                    }
                } else if (d != 0.0) {
                    n4 = j;
                }
                dArray2[n3 + 4 * j] = d;
            }
            n2 = 12;
            int n6 = n3 + 12;
            dArray2[n6] = dArray2[n6] / dArray[n2 + 3];
            dArray2[n3 + 8] = (dArray2[n3 + 8] - dArray[(n2 -= 4) + 3] * dArray2[n3 + 12]) / dArray[n2 + 2];
            dArray2[n3 + 4] = (dArray2[n3 + 4] - dArray[(n2 -= 4) + 2] * dArray2[n3 + 8] - dArray[n2 + 3] * dArray2[n3 + 12]) / dArray[n2 + 1];
            dArray2[n3 + 0] = (dArray2[n3 + 0] - dArray[(n2 -= 4) + 1] * dArray2[n3 + 4] - dArray[n2 + 2] * dArray2[n3 + 8] - dArray[n2 + 3] * dArray2[n3 + 12]) / dArray[n2 + 0];
        }
    }

    public final void mul(Matrix4d matrix4d) {
        double d = this.m00 * matrix4d.m00 + this.m01 * matrix4d.m10 + this.m02 * matrix4d.m20 + this.m03 * matrix4d.m30;
        double d2 = this.m00 * matrix4d.m01 + this.m01 * matrix4d.m11 + this.m02 * matrix4d.m21 + this.m03 * matrix4d.m31;
        double d3 = this.m00 * matrix4d.m02 + this.m01 * matrix4d.m12 + this.m02 * matrix4d.m22 + this.m03 * matrix4d.m32;
        double d4 = this.m00 * matrix4d.m03 + this.m01 * matrix4d.m13 + this.m02 * matrix4d.m23 + this.m03 * matrix4d.m33;
        double d5 = this.m10 * matrix4d.m00 + this.m11 * matrix4d.m10 + this.m12 * matrix4d.m20 + this.m13 * matrix4d.m30;
        double d6 = this.m10 * matrix4d.m01 + this.m11 * matrix4d.m11 + this.m12 * matrix4d.m21 + this.m13 * matrix4d.m31;
        double d7 = this.m10 * matrix4d.m02 + this.m11 * matrix4d.m12 + this.m12 * matrix4d.m22 + this.m13 * matrix4d.m32;
        double d8 = this.m10 * matrix4d.m03 + this.m11 * matrix4d.m13 + this.m12 * matrix4d.m23 + this.m13 * matrix4d.m33;
        double d9 = this.m20 * matrix4d.m00 + this.m21 * matrix4d.m10 + this.m22 * matrix4d.m20 + this.m23 * matrix4d.m30;
        double d10 = this.m20 * matrix4d.m01 + this.m21 * matrix4d.m11 + this.m22 * matrix4d.m21 + this.m23 * matrix4d.m31;
        double d11 = this.m20 * matrix4d.m02 + this.m21 * matrix4d.m12 + this.m22 * matrix4d.m22 + this.m23 * matrix4d.m32;
        double d12 = this.m20 * matrix4d.m03 + this.m21 * matrix4d.m13 + this.m22 * matrix4d.m23 + this.m23 * matrix4d.m33;
        double d13 = this.m30 * matrix4d.m00 + this.m31 * matrix4d.m10 + this.m32 * matrix4d.m20 + this.m33 * matrix4d.m30;
        double d14 = this.m30 * matrix4d.m01 + this.m31 * matrix4d.m11 + this.m32 * matrix4d.m21 + this.m33 * matrix4d.m31;
        double d15 = this.m30 * matrix4d.m02 + this.m31 * matrix4d.m12 + this.m32 * matrix4d.m22 + this.m33 * matrix4d.m32;
        double d16 = this.m30 * matrix4d.m03 + this.m31 * matrix4d.m13 + this.m32 * matrix4d.m23 + this.m33 * matrix4d.m33;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
    }

    public boolean equals(Matrix4d matrix4d) {
        try {
            return this.m00 == matrix4d.m00 && this.m01 == matrix4d.m01 && this.m02 == matrix4d.m02 && this.m03 == matrix4d.m03 && this.m10 == matrix4d.m10 && this.m11 == matrix4d.m11 && this.m12 == matrix4d.m12 && this.m13 == matrix4d.m13 && this.m20 == matrix4d.m20 && this.m21 == matrix4d.m21 && this.m22 == matrix4d.m22 && this.m23 == matrix4d.m23 && this.m30 == matrix4d.m30 && this.m31 == matrix4d.m31 && this.m32 == matrix4d.m32 && this.m33 == matrix4d.m33;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            Matrix4d matrix4d = (Matrix4d)object;
            return this.m00 == matrix4d.m00 && this.m01 == matrix4d.m01 && this.m02 == matrix4d.m02 && this.m03 == matrix4d.m03 && this.m10 == matrix4d.m10 && this.m11 == matrix4d.m11 && this.m12 == matrix4d.m12 && this.m13 == matrix4d.m13 && this.m20 == matrix4d.m20 && this.m21 == matrix4d.m21 && this.m22 == matrix4d.m22 && this.m23 == matrix4d.m23 && this.m30 == matrix4d.m30 && this.m31 == matrix4d.m31 && this.m32 == matrix4d.m32 && this.m33 == matrix4d.m33;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 1L;
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m00);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m01);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m02);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m03);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m10);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m11);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m12);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m13);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m20);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m21);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m22);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m23);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m30);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m31);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m32);
        l = 31L * l + VecMathUtil.doubleToLongBits(this.m33);
        return (int)(l ^ l >> 32);
    }

    public final void setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 0.0;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
    }

    public Object clone() {
        Matrix4d matrix4d = null;
        try {
            matrix4d = (Matrix4d)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return matrix4d;
    }
}

