/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.JunctionChecker.DigraphCreationTask;
import org.openstreetmap.josm.plugins.JunctionChecker.JunctionCheckerPlugin;
import org.openstreetmap.josm.plugins.JunctionChecker.PrepareJunctionCheckorSearch;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionCheckDialog
extends ToggleDialog
implements SelectionChangedListener {
    private final JunctionCheckerPlugin plugin;
    private static final long serialVersionUID = 2952292777351992696L;
    private final SideButton checkJunctionButton;
    private final SideButton createDigraphButton;
    private final SideButton searchJunctionButton;
    private final JCheckBox digraphsealcb;
    private final JCheckBox produceRelation;
    private final JCheckBox sccCB;
    private final JSpinner nways;
    private final SpinnerNumberModel smodel;
    private final JLabel nwayslabel;

    public JunctionCheckDialog(JunctionCheckerPlugin junctionCheckerGuiPlugin) {
        super(I18n.tr((String)"JunctionChecking", (Object[])new Object[0]), "junctionchecker", I18n.tr((String)"Open the junctionchecking window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:junctionchecker", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"junctions", (Object[])new Object[0])}), (int)74, (int)5007), 150);
        this.plugin = junctionCheckerGuiPlugin;
        JPanel digraphPanel = new JPanel(new GridLayout(1, 2));
        digraphPanel.setBorder(new TitledBorder(I18n.tr((String)"Channel-Digraph creation", (Object[])new Object[0])));
        this.digraphsealcb = new JCheckBox(I18n.tr((String)"seal Channel Digraph", (Object[])new Object[0]));
        this.digraphsealcb.setSelected(false);
        this.sccCB = new JCheckBox(I18n.tr((String)"calculate strong connected channels", (Object[])new Object[0]));
        this.sccCB.setSelected(true);
        digraphPanel.add(this.sccCB);
        JPanel jcPanel = new JPanel(new GridLayout(4, 1));
        jcPanel.setBorder(new TitledBorder(I18n.tr((String)"Junctionchecking/junctions searching", (Object[])new Object[0])));
        JPanel spinnerpanel = new JPanel(new GridLayout(1, 2));
        this.smodel = new SpinnerNumberModel(3, 1, 20, 1);
        this.nways = new JSpinner(this.smodel);
        this.nwayslabel = new JLabel(I18n.tr((String)"order of junction (n):", (Object[])new Object[0]));
        this.nwayslabel.setEnabled(false);
        spinnerpanel.add(this.nwayslabel);
        spinnerpanel.add(this.nways);
        this.produceRelation = new JCheckBox(I18n.tr((String)"produce OSM-Relations: junction", (Object[])new Object[0]));
        this.produceRelation.setToolTipText(I18n.tr((String)"if enabled the plugin produces osm-relations from the junction subgraphs", (Object[])new Object[0]));
        this.produceRelation.setSelected(true);
        this.produceRelation.setEnabled(false);
        jcPanel.add(this.produceRelation);
        jcPanel.add(spinnerpanel);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(digraphPanel);
        centerPanel.add(jcPanel);
        this.createDigraphButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.marktr((String)"Create"));
                this.putValue("ShortDescription", I18n.tr((String)"create the channel digraph", (Object[])new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"digraphcreation"));
            }

            public void actionPerformed(ActionEvent e) {
                DigraphCreationTask dct = new DigraphCreationTask(JunctionCheckDialog.this.plugin, JunctionCheckDialog.this.digraphsealcb.isSelected(), JunctionCheckDialog.this.sccCB.isSelected());
                Main.worker.submit((Runnable)((Object)dct));
                JunctionCheckDialog.this.setActivateJunctionCheckOrSearch(true);
            }
        });
        this.checkJunctionButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.marktr((String)"Check "));
                this.putValue("ShortDescription", I18n.tr((String)"check the subust for junction properties", (Object[])new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"junctioncheck"));
            }

            public void actionPerformed(ActionEvent e) {
                PrepareJunctionCheckorSearch pjc = new PrepareJunctionCheckorSearch(JunctionCheckDialog.this.plugin, JunctionCheckDialog.this.smodel.getNumber().intValue(), JunctionCheckDialog.this.produceRelation.isSelected());
                pjc.prepareJunctionCheck();
            }
        });
        this.checkJunctionButton.setEnabled(false);
        this.searchJunctionButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.marktr((String)"Search "));
                this.putValue("ShortDescription", I18n.tr((String)"search for junctions in the channel subset", (Object[])new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"junctionsearch"));
            }

            public void actionPerformed(ActionEvent e) {
                PrepareJunctionCheckorSearch pjc = new PrepareJunctionCheckorSearch(JunctionCheckDialog.this.plugin, JunctionCheckDialog.this.smodel.getNumber().intValue(), JunctionCheckDialog.this.produceRelation.isSelected());
                pjc.prepareJunctionSearch();
            }
        });
        this.searchJunctionButton.setEnabled(false);
        this.createLayout(centerPanel, false, Arrays.asList(this.createDigraphButton, this.checkJunctionButton, this.searchJunctionButton));
    }

    public void setActivateJunctionCheckOrSearch(boolean activate) {
        this.checkJunctionButton.setEnabled(activate);
        this.nways.setEnabled(activate);
        this.nwayslabel.setEnabled(activate);
        this.produceRelation.setEnabled(activate);
        this.searchJunctionButton.setEnabled(activate);
    }

    public void setActivateCreateDigraph(boolean activate) {
        this.createDigraphButton.setEnabled(activate);
        this.digraphsealcb.setEnabled(activate);
        this.sccCB.setEnabled(activate);
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
    }
}

