/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import reverter.ChangesetReverter;
import reverter.RevertChangesetTask;

public class RevertChangesetHandler
extends RequestHandler {
    public static final String command = "revert_changeset";
    public static final String permissionKey = "remotecontrol.permission.revert_changeset";
    public static final boolean permissionDefault = true;

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        try {
            int changesetId = Integer.parseInt((String)this.args.get("id"));
            Main.worker.submit((Runnable)((Object)new RevertChangesetTask(changesetId, ChangesetReverter.RevertType.FULL, true)));
        }
        catch (Exception ex) {
            System.out.println("RemoteControl: Error parsing revert_changeset remote control request:");
            ex.printStackTrace();
            throw new RequestHandler.RequestHandlerErrorException();
        }
    }

    public String[] getMandatoryParams() {
        return new String[]{"id"};
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return null;
    }

    public String getPermissionMessage() {
        return I18n.tr((String)"Remote Control has been asked to revert a changeset.", (Object[])new Object[0]);
    }
}

