/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiUtil;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.LaneGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.RoadGui;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GuiContainer {
    static final Color RED = new Color(234, 66, 108);
    static final Color GREEN = new Color(66, 234, 108);
    private static final GuiContainer EMPTY = new GuiContainer(ModelContainer.empty());
    private final ModelContainer mc;
    private final Point2D translation;
    private final double mpp;
    private final double scale;
    private final double laneWidth;
    private final Map<Junction, JunctionGui> junctions = new HashMap<Junction, JunctionGui>();
    private final Map<Road, RoadGui> roads = new HashMap<Road, RoadGui>();
    private final Stroke connectionStroke;

    public static GuiContainer empty() {
        return EMPTY;
    }

    public GuiContainer(ModelContainer mc) {
        Point2D origin = GuiContainer.avgOrigin(GuiUtil.locs(mc.getPrimaryJunctions()));
        LatLon originCoor = Main.getProjection().eastNorth2latlon(new EastNorth(origin.getX(), origin.getY()));
        LatLon relCoor = Main.getProjection().eastNorth2latlon(new EastNorth(origin.getX() + 1.0, origin.getY() + 1.0));
        double mpsu = relCoor.greatCircleDistance(originCoor) / Math.sqrt(2.0);
        this.mc = mc;
        this.translation = new Point2D.Double(-origin.getX(), -origin.getY());
        this.mpp = 0.2;
        this.scale = mpsu / this.mpp;
        this.laneWidth = 2.0 / this.mpp;
        this.connectionStroke = new BasicStroke((float)(this.laneWidth / 4.0), 1, 1);
        for (Junction j : mc.getPrimaryJunctions()) {
            this.getGui(j);
        }
    }

    private static Point2D avgOrigin(List<Point2D> locs) {
        if (locs.isEmpty()) {
            return new Point2D.Double(0.0, 0.0);
        }
        double x = 0.0;
        double y = 0.0;
        for (Point2D l : locs) {
            x += l.getX();
            y += l.getY();
        }
        return new Point2D.Double(x / (double)locs.size(), y / (double)locs.size());
    }

    public JunctionGui getGui(Junction j) {
        JunctionGui existing = this.junctions.get(j);
        if (existing != null) {
            return existing;
        }
        return new JunctionGui(this, j);
    }

    void register(JunctionGui j) {
        if (this.junctions.put(j.getModel(), j) != null) {
            throw new IllegalStateException();
        }
    }

    public RoadGui getGui(Road r) {
        RoadGui gui = this.roads.get(r);
        if (gui == null) {
            RoadGui newGui = new RoadGui(this, r);
            this.roads.put(r, newGui);
            return newGui;
        }
        return gui;
    }

    Point2D translateAndScale(Point2D loc) {
        return new Point2D.Double((loc.getX() + this.translation.getX()) * this.scale, (loc.getY() + this.translation.getY()) * this.scale);
    }

    public double getMpp() {
        return this.mpp;
    }

    public double getScale() {
        return this.scale;
    }

    public double getLaneWidth() {
        return this.laneWidth;
    }

    public Stroke getConnectionStroke() {
        return this.connectionStroke;
    }

    public LaneGui getGui(Lane lane) {
        RoadGui roadGui = this.roads.get(lane.getRoad());
        for (LaneGui l : roadGui.getLanes()) {
            if (!l.getModel().equals(lane)) continue;
            return l;
        }
        throw new IllegalArgumentException(I18n.tr((String)"No such lane.", (Object[])new Object[0]));
    }

    public ModelContainer getModel() {
        return this.mc;
    }

    public Rectangle2D getBounds() {
        if (this.isEmpty()) {
            return new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0);
        }
        ArrayList<Junction> primaries = new ArrayList<Junction>(this.mc.getPrimaryJunctions());
        ArrayList<Double> top = new ArrayList<Double>();
        ArrayList<Double> left = new ArrayList<Double>();
        ArrayList<Double> right = new ArrayList<Double>();
        ArrayList<Double> bottom = new ArrayList<Double>();
        for (Junction j : primaries) {
            JunctionGui g = this.getGui(j);
            Rectangle2D b = g.getBounds();
            top.add(b.getMinY());
            left.add(b.getMinX());
            right.add(b.getMaxX());
            bottom.add(b.getMaxY());
        }
        double t = (Double)Collections.min(top);
        double l = (Double)Collections.min(left);
        double r = (Double)Collections.max(right);
        double b = (Double)Collections.max(bottom);
        return new Rectangle2D.Double(l, t, r - l, b - t);
    }

    public GuiContainer recalculate() {
        return new GuiContainer(this.mc.recalculate());
    }

    public Iterable<RoadGui> getRoads() {
        return this.roads.values();
    }

    public Iterable<JunctionGui> getJunctions() {
        return this.junctions.values();
    }

    public boolean isEmpty() {
        return this.mc.isEmpty();
    }
}

