/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui.actions;

import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.ConvertToRelationAction;
import org.openstreetmap.josm.tools.I18n;

public class ConvertAllToRelationAction
extends ConvertToRelationAction {
    public ConvertAllToRelationAction() {
        super(I18n.tr((String)"Convert ALL streets.", (Object[])new Object[0]), "convert2rel_24", I18n.tr((String)"Create relation between street and related addresses for ALL streets in the current layer.", (Object[])new Object[0]), "fixaddresses/convertalltorelation");
    }

    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
    }

    public void addressEditActionPerformed(AddressEditContainer container) {
        if (container != null) {
            for (OSMStreet street : container.getStreetList()) {
                this.createRelationForStreet(street);
            }
        }
    }

    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(this.hasStreetsToConvert());
    }

    protected void updateEnabledState(AddressEditSelectionEvent event) {
        this.setEnabled(this.hasStreetsToConvert());
    }

    private boolean hasStreetsToConvert() {
        if (this.container != null) {
            for (OSMStreet street : this.container.getStreetList()) {
                if (!street.hasAddresses() || street.hasAssociatedStreetRelation()) continue;
                return true;
            }
        }
        return false;
    }
}

