/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.tagspec.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.plugins.tageditor.tagspec.KeyValuePair;
import org.openstreetmap.josm.plugins.tageditor.tagspec.ui.ITagSelectorListener;
import org.openstreetmap.josm.plugins.tageditor.tagspec.ui.TagsTable;
import org.openstreetmap.josm.plugins.tageditor.tagspec.ui.TagsTableColumnModel;
import org.openstreetmap.josm.plugins.tageditor.tagspec.ui.TagsTableModel;
import org.openstreetmap.josm.tools.I18n;

public class TabularTagSelector
extends JPanel {
    private TagsTable tagsTable;
    private JTextField tfFilter;
    private JButton btnApply;
    private JScrollPane scrollPane;
    private final ArrayList<ITagSelectorListener> listeners = new ArrayList();

    protected JPanel buildFilterPanel() {
        JPanel pnl = new JPanel();
        JLabel lbl = new JLabel(I18n.tr((String)"Search: ", (Object[])new Object[0]));
        pnl.setLayout(new FlowLayout(0));
        this.tfFilter = new JTextField(20);
        pnl.add(lbl);
        pnl.add((Component)this.tfFilter, "Center");
        JButton btn = new JButton(I18n.tr((String)"Filter", (Object[])new Object[0]));
        pnl.add(btn);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabularTagSelector.this.filter(TabularTagSelector.this.tfFilter.getText());
            }
        });
        btn = new JButton(I18n.tr((String)"Clear", (Object[])new Object[0]));
        pnl.add(btn);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabularTagSelector.this.tfFilter.setText("");
                TabularTagSelector.this.tfFilter.requestFocus();
            }
        });
        return pnl;
    }

    protected JScrollPane buildPresetGrid() {
        this.tagsTable = new TagsTable(new TagsTableModel(), new TagsTableColumnModel());
        this.getModel().initFromTagSpecifications();
        this.scrollPane = new JScrollPane(this.tagsTable);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                Dimension d = TabularTagSelector.this.scrollPane.getViewport().getExtentSize();
                TabularTagSelector.this.tagsTable.adjustColumnWidth(d.width);
            }
        });
        this.tagsTable.addMouseListener(new DoubleClickAdapter());
        this.tagsTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        ActionListener enterAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int rowNum = TabularTagSelector.this.tagsTable.getSelectedRow();
                if (rowNum >= 0) {
                    KeyValuePair item = TabularTagSelector.this.getModel().getVisibleItem(rowNum);
                    TabularTagSelector.this.fireItemSelected(item);
                }
            }
        };
        this.tagsTable.registerKeyboardAction(enterAction, "Enter", KeyStroke.getKeyStroke(10, 0), 0);
        return this.scrollPane;
    }

    protected JPanel buildControlButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        this.btnApply = new JButton("Apply");
        pnl.add(this.btnApply);
        this.btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int row = TabularTagSelector.this.tagsTable.getSelectedRow();
                if (row >= 0) {
                    KeyValuePair item = TabularTagSelector.this.getModel().getVisibleItem(row);
                    TabularTagSelector.this.fireItemSelected(item);
                }
            }
        });
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildFilterPanel(), "North");
        this.add((Component)this.buildPresetGrid(), "Center");
        this.add((Component)this.buildControlButtonPanel(), "South");
        this.tfFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                this.onUpdate();
            }

            public void insertUpdate(DocumentEvent arg0) {
                this.onUpdate();
            }

            public void removeUpdate(DocumentEvent arg0) {
                this.onUpdate();
            }

            protected void onUpdate() {
                TabularTagSelector.this.filter(TabularTagSelector.this.tfFilter.getText());
            }
        });
        this.tfFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabularTagSelector.this.filter(TabularTagSelector.this.tfFilter.getText());
            }
        });
        this.tagsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TabularTagSelector.this.btnApply.setEnabled(TabularTagSelector.this.tagsTable.getSelectedRowCount() != 0);
            }
        });
        this.tagsTable.getSelectionModel().clearSelection();
        this.btnApply.setEnabled(false);
    }

    public TabularTagSelector() {
        this.build();
    }

    public void filter(String filter) {
        this.tagsTable.getSelectionModel().clearSelection();
        this.getModel().filter(filter);
        this.tagsTable.scrollRectToVisible(this.tagsTable.getCellRect(0, 0, false));
        for (Container c = this.tagsTable; c != null; c = c.getParent()) {
            ((Component)c).doLayout();
            c.repaint();
        }
    }

    protected TagsTableModel getModel() {
        return (TagsTableModel)this.tagsTable.getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTagSelectorListener(ITagSelectorListener listener) {
        ArrayList<ITagSelectorListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (listener != null && !this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTagSelectorListener(ITagSelectorListener listener) {
        ArrayList<ITagSelectorListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireItemSelected(KeyValuePair pair) {
        ArrayList<ITagSelectorListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (ITagSelectorListener listener : this.listeners) {
                listener.itemSelected(pair);
            }
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int rowNum = TabularTagSelector.this.tagsTable.rowAtPoint(e.getPoint());
                KeyValuePair pair = TabularTagSelector.this.getModel().getVisibleItem(rowNum);
                TabularTagSelector.this.fireItemSelected(pair);
            }
        }
    }
}

