/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.show;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.MapdustShowAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.FilterBugDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;

public class ShowFilterBugAction
extends MapdustShowAction {
    private static final long serialVersionUID = -5627314630613341777L;

    public ShowFilterBugAction() {
    }

    public ShowFilterBugAction(MapdustPlugin mapdustPlugin) {
        this.setMapdustPlugin(mapdustPlugin);
        this.setTitle("Filter bug reports");
        this.setIconName("dialogs/mapdust_bug_filter.png");
    }

    public void actionPerformed(ActionEvent event) {
        if (event != null) {
            JToggleButton btn = null;
            if (event.getSource() instanceof JToggleButton) {
                btn = (JToggleButton)event.getSource();
                btn.setSelected(true);
            } else if (event.getSource() instanceof JMenuItem) {
                this.getButtonPanel().getBtnFilter().setSelected(true);
            }
            MapdustBug selectedBug = this.mapdustPlugin.getMapdustGUI().getSelectedBug();
            if (selectedBug != null) {
                Main.pref.put("selectedBug.status", selectedBug.getStatus().getValue());
            } else {
                Main.pref.put("selectedBug.status", "");
            }
            this.disableButtons(this.getButtonPanel());
            FilterBugDialog dialog = new FilterBugDialog(this.getTitle(), this.getIconName(), btn, this.getMapdustPlugin());
            dialog.setLocationRelativeTo(null);
            dialog.getContentPane().setPreferredSize(dialog.getSize());
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    void disableButtons(MapdustButtonPanel buttonPanel) {
        if (buttonPanel != null) {
            buttonPanel.getBtnWorkOffline().setEnabled(false);
            buttonPanel.getBtnWorkOffline().setSelected(false);
            buttonPanel.getBtnWorkOffline().setFocusable(false);
            buttonPanel.getBtnRefresh().setEnabled(false);
            buttonPanel.getBtnRefresh().setSelected(false);
            buttonPanel.getBtnRefresh().setFocusable(false);
            buttonPanel.getBtnReOpenBugReport().setEnabled(false);
            buttonPanel.getBtnReOpenBugReport().setSelected(false);
            buttonPanel.getBtnReOpenBugReport().setFocusable(false);
            buttonPanel.getBtnAddComment().setEnabled(false);
            buttonPanel.getBtnAddComment().setSelected(false);
            buttonPanel.getBtnAddComment().setFocusable(false);
            buttonPanel.getBtnInvalidateBugReport().setEnabled(false);
            buttonPanel.getBtnInvalidateBugReport().setSelected(false);
            buttonPanel.getBtnInvalidateBugReport().setFocusable(false);
            buttonPanel.getBtnFixBugReport().setEnabled(false);
            buttonPanel.getBtnFixBugReport().setSelected(false);
            buttonPanel.getBtnFixBugReport().setFocusable(false);
        }
    }
}

