/*
 * Decompiled with CFR 0.152.
 */
package gpxfilter;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.xml.sax.SAXException;

public class GpxGrabber
extends OsmServerReader {
    private final double lat1;
    private final double lon1;
    private final double lat2;
    private final double lon2;
    private int page;

    public GpxGrabber(Bounds downloadArea) {
        this.lat1 = downloadArea.getMin().lat();
        this.lon1 = downloadArea.getMin().lon();
        this.lat2 = downloadArea.getMax().lat();
        this.lon2 = downloadArea.getMax().lon();
        this.page = 0;
    }

    public GpxData parseRawGps() throws IOException, SAXException, OsmTransferException {
        try {
            String url = "trackpoints?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=" + this.page;
            InputStream in = this.getInputStream(url, NullProgressMonitor.INSTANCE);
            GpxReader reader = new GpxReader(in);
            reader.parse(false);
            GpxData result = reader.data;
            in.close();
            result.fromServer = true;
            ++this.page;
            return result;
        }
        catch (IllegalArgumentException e) {
            if (this.cancel) {
                return null;
            }
            throw new SAXException("Illegal characters within the HTTP-header response.", e);
        }
        catch (IOException e) {
            if (this.cancel) {
                return null;
            }
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (this.cancel) {
                return null;
            }
            throw e;
        }
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }
}

