/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui.actions;

import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.AbstractAddressEditAction;
import org.openstreetmap.josm.tools.I18n;

public class ConvertToRelationAction
extends AbstractAddressEditAction {
    public ConvertToRelationAction() {
        super(I18n.tr((String)"Convert to relation.", (Object[])new Object[0]), "convert2rel_24", I18n.tr((String)"Create relation between street and related addresses.", (Object[])new Object[0]), "fixaddresses/converttorelation");
    }

    public ConvertToRelationAction(String name, String iconName, String tooltip, String toolbar) {
        super(name, iconName, tooltip, toolbar);
    }

    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        OSMStreet streetNode = ev.getSelectedStreet();
        if (streetNode != null) {
            this.createRelationForStreet(streetNode);
        }
    }

    protected void createRelationForStreet(OSMStreet streetNode) {
        if (streetNode == null || !streetNode.hasAddresses()) {
            return;
        }
        this.beginTransaction(I18n.tr((String)"Create address relation for ", (Object[])new Object[0]) + " '" + streetNode.getName() + "'");
        Relation r = new Relation();
        this.commands.add(new AddCommand((OsmPrimitive)r));
        this.commands.add(new ChangePropertyCommand((OsmPrimitive)r, "name", streetNode.getName()));
        this.commands.add(new ChangePropertyCommand((OsmPrimitive)r, "type", "associatedStreet"));
        r.addMember(new RelationMember("street", streetNode.getOsmObject()));
        for (OSMAddress addrNode : streetNode.getAddresses()) {
            this.beginObjectTransaction(addrNode);
            r.addMember(new RelationMember("house", addrNode.getOsmObject()));
            addrNode.setStreetName(null);
            this.finishObjectTransaction(addrNode);
        }
        this.finishTransaction();
    }

    public void addressEditActionPerformed(AddressEditContainer container) {
    }

    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(false);
    }

    protected void updateEnabledState(AddressEditSelectionEvent event) {
        if (event == null) {
            return;
        }
        OSMStreet street = event.getSelectedStreet();
        this.setEnabled(street != null && street.hasAddresses() && !street.hasAssociatedStreetRelation());
    }
}

