/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.licensechange;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.licensechange.Check;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangeVisitor;
import org.openstreetmap.josm.plugins.licensechange.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseProblem {
    private Severity severity;
    private String message;
    private List<? extends OsmPrimitive> primitives;
    private List<?> highlighted;
    private Check tester;
    private boolean selected;

    public LicenseProblem(Check tester, Severity severity, String message, List<? extends OsmPrimitive> primitives, List<?> highlighted) {
        this.tester = tester;
        this.severity = severity;
        this.message = message;
        this.primitives = primitives;
        this.highlighted = highlighted;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<? extends OsmPrimitive> getPrimitives() {
        return this.primitives;
    }

    public void setPrimitives(List<OsmPrimitive> primitives) {
        this.primitives = primitives;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Check getTester() {
        return this.tester;
    }

    public void paint(Graphics g, MapView mv) {
        PaintVisitor v = new PaintVisitor(g, mv);
        this.visitHighlighted(v);
    }

    public void visitHighlighted(LicenseChangeVisitor v) {
        for (Object o : this.highlighted) {
            if (o instanceof OsmPrimitive) {
                v.visit((OsmPrimitive)o);
                continue;
            }
            if (!(o instanceof List)) continue;
            v.visit((List)o);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PaintVisitor
    extends AbstractVisitor
    implements LicenseChangeVisitor {
        private final Graphics g;
        private final MapView mv;

        public PaintVisitor(Graphics g, MapView mv) {
            this.g = g;
            this.mv = mv;
        }

        @Override
        public void visit(OsmPrimitive p) {
            if (p.isUsable()) {
                p.visit((Visitor)this);
            }
        }

        public void drawNode(Node n, Color color) {
            Point p = this.mv.getPoint(n);
            this.g.setColor(color);
            if (LicenseProblem.this.selected) {
                this.g.fillOval(p.x - 6, p.y - 6, 12, 12);
            } else {
                this.g.drawOval(p.x - 6, p.y - 6, 12, 12);
            }
        }

        public void drawSegment(Point p1, Point p2, boolean linecapStart, boolean linecapEnd, Color color) {
            this.g.setColor(color);
            double t = Math.atan2(p2.x - p1.x, p2.y - p1.y);
            double cosT = Math.cos(t);
            double sinT = Math.sin(t);
            int deg = (int)Math.toDegrees(t);
            if (LicenseProblem.this.selected) {
                int[] x = new int[]{(int)((double)p1.x + 4.0 * cosT), (int)((double)p2.x + 4.0 * cosT), (int)((double)p2.x - 4.0 * cosT), (int)((double)p1.x - 4.0 * cosT)};
                int[] y = new int[]{(int)((double)p1.y - 4.0 * sinT), (int)((double)p2.y - 4.0 * sinT), (int)((double)p2.y + 4.0 * sinT), (int)((double)p1.y + 4.0 * sinT)};
                this.g.fillPolygon(x, y, 4);
                if (linecapStart) {
                    this.g.fillArc(p1.x - 4, p1.y - 4, 8, 8, deg, 180);
                }
                if (linecapEnd) {
                    this.g.fillArc(p2.x - 4, p2.y - 4, 8, 8, deg, -180);
                }
            } else {
                this.g.drawLine((int)((double)p1.x + 4.0 * cosT), (int)((double)p1.y - 4.0 * sinT), (int)((double)p2.x + 4.0 * cosT), (int)((double)p2.y - 4.0 * sinT));
                this.g.drawLine((int)((double)p1.x - 4.0 * cosT), (int)((double)p1.y + 4.0 * sinT), (int)((double)p2.x - 4.0 * cosT), (int)((double)p2.y + 4.0 * sinT));
                if (linecapStart) {
                    this.g.drawArc(p1.x - 4, p1.y - 4, 8, 8, deg, 180);
                }
                if (linecapEnd) {
                    this.g.drawArc(p2.x - 4, p2.y - 4, 8, 8, deg, -180);
                }
            }
        }

        public void drawSegment(Node n1, Node n2, boolean linecapStart, boolean linecapEnd, Color color) {
            this.drawSegment(this.mv.getPoint(n1), this.mv.getPoint(n2), linecapStart, linecapEnd, color);
        }

        public void visit(Node n) {
            if (this.isNodeVisible(n)) {
                this.drawNode(n, LicenseProblem.this.severity.getColor());
            }
        }

        public void visit(Way w) {
            this.visit(w.getNodes());
        }

        public void visit(Relation r) {
        }

        protected boolean isNodeVisible(Node n) {
            Point p = this.mv.getPoint(n);
            return p.x >= 0 && p.y >= 0 && p.x <= this.mv.getWidth() && p.y <= this.mv.getHeight();
        }

        protected boolean isSegmentVisible(Node n1, Node n2) {
            Point p1 = this.mv.getPoint(n1);
            Point p2 = this.mv.getPoint(n2);
            if (p1.x < 0 && p2.x < 0) {
                return false;
            }
            if (p1.y < 0 && p2.y < 0) {
                return false;
            }
            if (p1.x > this.mv.getWidth() && p2.x > this.mv.getWidth()) {
                return false;
            }
            return p1.y <= this.mv.getHeight() || p2.y <= this.mv.getHeight();
        }

        @Override
        public void visit(List<Node> nodes) {
            Node[] window = new Node[4];
            int index = 1;
            window[0] = null;
            for (Node n : nodes) {
                if (index == 1) {
                    window[1] = n;
                    index = 2;
                    continue;
                }
                window[index++] = n;
                if (index != 4) continue;
                this.drawSegment(window[1], window[2], window[0] == null, !this.isSegmentVisible(window[2], window[3]), LicenseProblem.this.severity.getColor());
                window[0] = window[1];
                window[1] = window[2];
                window[2] = window[3];
                index = 3;
            }
            if (window[1] != null && window[2] != null) {
                this.drawSegment(window[1], window[2], window[0] == null, true, LicenseProblem.this.severity.getColor());
            }
        }
    }
}

