/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectModWaysAction
extends JosmAction {
    private int lastHash;
    private Command lastCmd;

    public SelectModWaysAction() {
        super(I18n.tr((String)"Select last modified ways", (Object[])new Object[0]), "selmodways", I18n.tr((String)"Select last modified ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selmodways", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Select last modified ways"}), (int)90, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectLastModifiedWays"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = SelectModWaysAction.getCurrentDataSet().getSelected();
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        SelectModWaysAction.getCurrentDataSet().clearSelection((Collection)selectedNodes);
        Command cmd = null;
        if (Main.main.undoRedo.commands == null) {
            return;
        }
        int num = Main.main.undoRedo.commands.size();
        if (num == 0) {
            return;
        }
        int k = 0;
        int idx = selection != null && !selection.isEmpty() && selection.hashCode() == this.lastHash ? Main.main.undoRedo.commands.indexOf(this.lastCmd) : num;
        HashSet<Way> ways = new HashSet<Way>(10);
        do {
            idx = idx > 0 ? --idx : num - 1;
            cmd = (Command)Main.main.undoRedo.commands.get(idx);
            Collection pp = cmd.getParticipatingPrimitives();
            ways.clear();
            for (OsmPrimitive p : pp) {
                if (!(p instanceof Way) || p.isDeleted()) continue;
                ways.add((Way)p);
            }
            if (ways.isEmpty() || SelectModWaysAction.getCurrentDataSet().getSelected().containsAll(ways)) continue;
            SelectModWaysAction.getCurrentDataSet().setSelected(ways);
            this.lastCmd = cmd;
            this.lastHash = SelectModWaysAction.getCurrentDataSet().getSelected().hashCode();
            return;
        } while (++k < num);
        this.lastCmd = null;
        this.lastHash = 0;
    }

    protected void updateEnabledState() {
        if (SelectModWaysAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SelectModWaysAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(true);
    }
}

