/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.List;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;

public final class CRSUtilities {
    private CRSUtilities() {
    }

    private static List<CoordinateReferenceSystem> getComponents(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<CoordinateReferenceSystem> list;
        if (coordinateReferenceSystem instanceof CompoundCRS && !(list = ((CompoundCRS)coordinateReferenceSystem).getCoordinateReferenceSystems()).isEmpty()) {
            return list;
        }
        return null;
    }

    public static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem instanceof SingleCRS ? ((SingleCRS)coordinateReferenceSystem).getDatum() : null;
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (!(coordinateReferenceSystem instanceof GeographicCRS)) {
            List<CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
            if (list == null) {
                return null;
            }
            coordinateReferenceSystem = list.get(0);
        }
        return ((GeographicCRS)coordinateReferenceSystem).getDatum().getEllipsoid();
    }
}

