/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class MathTransformProxy
implements MathTransform,
Serializable {
    private static final long serialVersionUID = 8844242705205498128L;
    public final MathTransform transform;

    protected MathTransformProxy(MathTransform mathTransform) {
        this.transform = mathTransform;
    }

    @Override
    public int getSourceDimensions() {
        return this.transform.getTargetDimensions();
    }

    @Override
    public int getTargetDimensions() {
        return this.transform.getSourceDimensions();
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedDimensionException, TransformException {
        return this.transform.transform(directPosition, directPosition2);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        this.transform.transform(dArray, n, dArray2, n2, n3);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        this.transform.transform(fArray, n, fArray2, n2, n3);
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        ((AbstractMathTransform)this.transform).transform(fArray, n, dArray, n2, n3);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        ((AbstractMathTransform)this.transform).transform(dArray, n, fArray, n2, n3);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        return this.transform.derivative(directPosition);
    }

    @Override
    public MathTransform inverse() throws NoninvertibleTransformException {
        return this.transform.inverse();
    }

    @Override
    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    public String toString() {
        return this.transform.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            MathTransformProxy mathTransformProxy = (MathTransformProxy)object;
            return Utilities.equals(this.transform, mathTransformProxy.transform);
        }
        return false;
    }

    public int hashCode() {
        return this.transform.hashCode() ^ 0xAF1D1110;
    }
}

