/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConstantTransform1D;
import org.geotools.referencing.operation.transform.IdentityTransform1D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class LinearTransform1D
extends AbstractMathTransform
implements MathTransform1D,
LinearTransform,
Serializable {
    private static final long serialVersionUID = -7595037195668813000L;
    public static final LinearTransform1D IDENTITY = IdentityTransform1D.ONE;
    public final double scale;
    public final double offset;
    private transient MathTransform1D inverse;

    protected LinearTransform1D(double d, double d2) {
        this.scale = d;
        this.offset = d2;
    }

    public static LinearTransform1D create(double d, double d2) {
        if (d == 0.0) {
            return new ConstantTransform1D(d2);
        }
        if (d == 1.0 && d2 == 0.0) {
            return IDENTITY;
        }
        return new LinearTransform1D(d, d2);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return ProjectiveTransform.ProviderAffine.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getTargetDimensions() {
        return 1;
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix2(this.scale, this.offset, 0.0, 1.0);
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else if (this.scale != 0.0) {
                LinearTransform1D linearTransform1D = LinearTransform1D.create(1.0 / this.scale, -this.offset / this.scale);
                linearTransform1D.inverse = this;
                this.inverse = linearTransform1D;
            } else {
                this.inverse = (MathTransform1D)super.inverse();
            }
        }
        return this.inverse;
    }

    @Override
    public boolean isIdentity() {
        return this.isIdentity(0.0);
    }

    @Override
    public boolean isIdentity(double d) {
        d = Math.abs(d);
        return Math.abs(this.offset) <= d && Math.abs(this.scale - 1.0) <= d;
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        return new Matrix1(this.scale);
    }

    @Override
    public double derivative(double d) {
        return this.scale;
    }

    @Override
    public double transform(double d) {
        return this.offset + this.scale * d;
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)(this.offset + this.scale * (double)fArray[n++]);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)(this.offset + this.scale * (double)fArray[--n]);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = this.offset + this.scale * dArray[n++];
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = this.offset + this.scale * dArray[--n];
            }
        }
    }

    @Override
    public int hashCode() {
        long l = 675810104L + Double.doubleToRawLongBits(this.offset);
        l = l * 37L + Double.doubleToRawLongBits(this.scale);
        return (int)(l >>> 32) ^ (int)l;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LinearTransform1D linearTransform1D = (LinearTransform1D)object;
            return Double.doubleToRawLongBits(this.scale) == Double.doubleToRawLongBits(linearTransform1D.scale) && Double.doubleToRawLongBits(this.offset) == Double.doubleToRawLongBits(linearTransform1D.offset);
        }
        return false;
    }
}

