/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;

abstract class AuthorityFactoryProxy {
    private static final Class[] TYPES = new Class[]{CoordinateOperation.class, OperationMethod.class, ParameterDescriptor.class, ProjectedCRS.class, GeographicCRS.class, GeocentricCRS.class, ImageCRS.class, DerivedCRS.class, VerticalCRS.class, TemporalCRS.class, EngineeringCRS.class, CompoundCRS.class, CoordinateReferenceSystem.class, CoordinateSystemAxis.class, CartesianCS.class, EllipsoidalCS.class, SphericalCS.class, CylindricalCS.class, PolarCS.class, VerticalCS.class, TimeCS.class, CoordinateSystem.class, PrimeMeridian.class, Ellipsoid.class, GeodeticDatum.class, ImageDatum.class, VerticalDatum.class, TemporalDatum.class, EngineeringDatum.class, Datum.class, IdentifiedObject.class};

    AuthorityFactoryProxy() {
    }

    public static AuthorityFactoryProxy getInstance(AuthorityFactory authorityFactory, Class clazz) {
        AbstractAuthorityFactory.ensureNonNull("type", clazz);
        AbstractAuthorityFactory.ensureNonNull("factory", authorityFactory);
        clazz = AuthorityFactoryProxy.getType(clazz);
        if (authorityFactory instanceof CRSAuthorityFactory) {
            CRSAuthorityFactory cRSAuthorityFactory = (CRSAuthorityFactory)authorityFactory;
            if (clazz.equals(ProjectedCRS.class)) {
                return new Projected(cRSAuthorityFactory);
            }
            if (clazz.equals(GeographicCRS.class)) {
                return new Geographic(cRSAuthorityFactory);
            }
            if (clazz.equals(CoordinateReferenceSystem.class)) {
                return new CRS(cRSAuthorityFactory);
            }
        }
        return new Default(authorityFactory, clazz);
    }

    public static Class getType(Class clazz) throws IllegalArgumentException {
        for (int i = 0; i < TYPES.length; ++i) {
            Class clazz2 = TYPES[i];
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return clazz2;
        }
        throw new IllegalArgumentException(Errors.format(61, clazz, IdentifiedObject.class));
    }

    public abstract Class getType();

    public abstract AuthorityFactory getAuthorityFactory();

    public final Set getAuthorityCodes() throws FactoryException {
        return this.getAuthorityFactory().getAuthorityCodes(this.getType());
    }

    public abstract IdentifiedObject create(String var1) throws NoSuchAuthorityCodeException, FactoryException;

    public String toString() {
        return this.toString(AuthorityFactoryProxy.class);
    }

    final String toString(Class clazz) {
        AuthorityFactory authorityFactory = this.getAuthorityFactory();
        return Classes.getShortName(clazz) + '[' + Classes.getShortName(this.getType()) + " in " + Classes.getShortClassName(authorityFactory) + "(\"" + authorityFactory.getAuthority().getTitle() + "\")]";
    }

    private static final class Projected
    extends CRS {
        protected Projected(CRSAuthorityFactory cRSAuthorityFactory) {
            super(cRSAuthorityFactory);
        }

        @Override
        public Class getType() {
            return ProjectedCRS.class;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            return this.factory.createProjectedCRS(string);
        }
    }

    private static final class Geographic
    extends CRS {
        protected Geographic(CRSAuthorityFactory cRSAuthorityFactory) {
            super(cRSAuthorityFactory);
        }

        @Override
        public Class getType() {
            return GeographicCRS.class;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            return this.factory.createGeographicCRS(string);
        }
    }

    private static class CRS
    extends AuthorityFactoryProxy {
        protected final CRSAuthorityFactory factory;

        protected CRS(CRSAuthorityFactory cRSAuthorityFactory) {
            this.factory = cRSAuthorityFactory;
        }

        @Override
        public Class getType() {
            return CoordinateReferenceSystem.class;
        }

        @Override
        public final AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            return this.factory.createCoordinateReferenceSystem(string);
        }
    }

    private static final class Default
    extends AuthorityFactoryProxy {
        private static final Class[] PARAMETERS = new Class[]{String.class};
        private final AuthorityFactory factory;
        private final Class type;
        private final Method method;

        Default(AuthorityFactory authorityFactory, Class clazz) throws IllegalArgumentException {
            this.factory = authorityFactory;
            this.type = clazz;
            Method[] methodArray = authorityFactory.getClass().getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.getName().startsWith("create") || !clazz.equals(method.getReturnType()) || !Arrays.equals(PARAMETERS, method.getParameterTypes())) continue;
                this.method = method;
                return;
            }
            throw new IllegalArgumentException(Errors.format(187, clazz));
        }

        @Override
        public Class getType() {
            return this.type;
        }

        @Override
        public AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            try {
                return (IdentifiedObject)this.method.invoke((Object)this.factory, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof FactoryException) {
                    throw (FactoryException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new FactoryException(throwable.getLocalizedMessage(), throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FactoryException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
            }
        }
    }
}

