/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.AbstractCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class DefaultCompoundCS
extends AbstractCS {
    private static final long serialVersionUID = -5726410275278843372L;
    private final CoordinateSystem[] cs;
    private transient List<CoordinateSystem> asList;

    public DefaultCompoundCS(CoordinateSystem[] coordinateSystemArray) {
        coordinateSystemArray = DefaultCompoundCS.clone(coordinateSystemArray);
        super(DefaultCompoundCS.getName(coordinateSystemArray), DefaultCompoundCS.getAxis(coordinateSystemArray));
        this.cs = coordinateSystemArray;
    }

    private static CoordinateSystem[] clone(CoordinateSystem[] coordinateSystemArray) {
        DefaultCompoundCS.ensureNonNull("cs", coordinateSystemArray);
        coordinateSystemArray = (CoordinateSystem[])coordinateSystemArray.clone();
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            DefaultCompoundCS.ensureNonNull("cs", coordinateSystemArray, i);
        }
        return coordinateSystemArray;
    }

    private static CoordinateSystemAxis[] getAxis(CoordinateSystem[] coordinateSystemArray) {
        int n = 0;
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            n += coordinateSystemArray[i].getDimension();
        }
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n];
        n = 0;
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            CoordinateSystem coordinateSystem = coordinateSystemArray[i];
            int n2 = coordinateSystem.getDimension();
            for (int j = 0; j < n2; ++j) {
                coordinateSystemAxisArray[n++] = coordinateSystem.getAxis(j);
            }
        }
        assert (n == coordinateSystemAxisArray.length);
        return coordinateSystemAxisArray;
    }

    private static String getName(CoordinateSystem[] coordinateSystemArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" / ");
            }
            stringBuilder.append(coordinateSystemArray[i].getName().getCode());
        }
        return stringBuilder.toString();
    }

    public synchronized List<CoordinateSystem> getCoordinateSystems() {
        if (this.asList == null) {
            this.asList = Collections.unmodifiableList(Arrays.asList(this.cs));
        }
        return this.asList;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultCompoundCS defaultCompoundCS = (DefaultCompoundCS)abstractIdentifiedObject;
            return DefaultCompoundCS.equals(this.cs, defaultCompoundCS.cs, bl);
        }
        return false;
    }
}

