/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DirectionAlongMeridian;
import org.geotools.referencing.cs.PredefinedCS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.InternationalString;

public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    private static final long serialVersionUID = 6757665252533744744L;
    private static final DefaultCoordinateSystemAxis[] DIRECTION_CHECKS = new DefaultCoordinateSystemAxis[]{DefaultCoordinateSystemAxis.NORTHING, DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.SOUTHING, DefaultCoordinateSystemAxis.WESTING};
    private final CoordinateSystemAxis[] axis;
    private transient Unit<?> distanceUnit;

    public AbstractCS(String string, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        this(Collections.singletonMap("name", string), coordinateSystemAxisArray);
    }

    public AbstractCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map);
        AbstractCS.ensureNonNull("axis", coordinateSystemAxisArray);
        this.axis = (CoordinateSystemAxis[])coordinateSystemAxisArray.clone();
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            Object object;
            AbstractCS.ensureNonNull("axis", coordinateSystemAxisArray, i);
            AxisDirection axisDirection = coordinateSystemAxisArray[i].getDirection();
            AbstractCS.ensureNonNull("direction", axisDirection);
            if (!this.isCompatibleDirection(axisDirection)) {
                throw new IllegalArgumentException(Errors.format(60, axisDirection.name(), this.getClass()));
            }
            Unit<?> unit = coordinateSystemAxisArray[i].getUnit();
            AbstractCS.ensureNonNull("unit", unit);
            if (!this.isCompatibleUnit(axisDirection, unit)) {
                throw new IllegalArgumentException(Errors.format(76, unit));
            }
            AxisDirection axisDirection2 = axisDirection.absolute();
            if (!axisDirection2.equals(AxisDirection.OTHER)) {
                int n = i;
                while (--n >= 0) {
                    if (!axisDirection2.equals(coordinateSystemAxisArray[n].getDirection().absolute())) continue;
                    String string = coordinateSystemAxisArray[i].getDirection().name();
                    object = coordinateSystemAxisArray[n].getDirection().name();
                    throw new IllegalArgumentException(Errors.format(36, string, object));
                }
            }
            String string = coordinateSystemAxisArray[i].getName().getCode();
            for (int j = 0; j < DIRECTION_CHECKS.length; ++j) {
                DirectionAlongMeridian directionAlongMeridian;
                AxisDirection axisDirection3;
                object = DIRECTION_CHECKS[j];
                if (!((DefaultCoordinateSystemAxis)object).nameMatches(string) || axisDirection.equals(axisDirection3 = ((DefaultCoordinateSystemAxis)object).getDirection()) || (directionAlongMeridian = DirectionAlongMeridian.parse(axisDirection)) != null) continue;
                throw new IllegalArgumentException(Errors.format(77, string, axisDirection.name()));
            }
        }
    }

    static Map<String, Object> name(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        InternationalString internationalString = Vocabulary.formatInternational(n);
        hashMap.put("name", internationalString.toString());
        hashMap.put("alias", internationalString);
        return hashMap;
    }

    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return true;
    }

    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        return true;
    }

    @Override
    public int getDimension() {
        return this.axis.length;
    }

    @Override
    public CoordinateSystemAxis getAxis(int n) throws IndexOutOfBoundsException {
        return this.axis[n];
    }

    private static AxisDirection[] getAxisDirections(CoordinateSystem coordinateSystem) {
        AxisDirection[] axisDirectionArray = new AxisDirection[coordinateSystem.getDimension()];
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            axisDirectionArray[i] = coordinateSystem.getAxis(i).getDirection();
        }
        return axisDirectionArray;
    }

    public static Matrix swapAndScaleAxis(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws IllegalArgumentException, ConversionException {
        if (!Classes.sameInterfaces(coordinateSystem.getClass(), coordinateSystem2.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Errors.format(73));
        }
        Object[] objectArray = AbstractCS.getAxisDirections(coordinateSystem);
        Object[] objectArray2 = AbstractCS.getAxisDirections(coordinateSystem2);
        GeneralMatrix generalMatrix = new GeneralMatrix((AxisDirection[])objectArray, (AxisDirection[])objectArray2);
        assert (Arrays.equals(objectArray, objectArray2) == generalMatrix.isIdentity()) : generalMatrix;
        int n = generalMatrix.getNumCol() - 1;
        int n2 = generalMatrix.getNumRow() - 1;
        assert (n == coordinateSystem.getDimension()) : coordinateSystem;
        assert (n2 == coordinateSystem2.getDimension()) : coordinateSystem2;
        for (int i = 0; i < n2; ++i) {
            Unit<?> unit = coordinateSystem2.getAxis(i).getUnit();
            for (int j = 0; j < n; ++j) {
                Unit<?> unit2;
                double d = generalMatrix.getElement(i, j);
                if (d == 0.0 || Utilities.equals(unit2 = coordinateSystem.getAxis(j).getUnit(), unit)) continue;
                UnitConverter unitConverter = unit2.getConverterTo(unit);
                if (!unitConverter.isLinear()) {
                    throw new ConversionException(Errors.format(114, unit2, unit));
                }
                double d2 = unitConverter.convert(0.0);
                double d3 = unitConverter.convert(1.0) - d2;
                generalMatrix.setElement(i, j, d * d3);
                generalMatrix.setElement(i, n, generalMatrix.getElement(i, n) + d * d2);
            }
        }
        return generalMatrix;
    }

    public static CoordinateSystem standard(CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        return PredefinedCS.standard(coordinateSystem);
    }

    final Unit<?> getDistanceUnit() throws ConversionException {
        Unit<?> unit = this.distanceUnit;
        if (unit == null) {
            for (int i = 0; i < this.axis.length; ++i) {
                Unit<Angle> unit2 = this.axis[i].getUnit();
                if (unit2 == null || unit2.isCompatible(SI.RADIAN)) continue;
                if (unit != null) {
                    UnitConverter unitConverter = unit2.getConverterTo(unit);
                    if (!unitConverter.isLinear()) {
                        throw new ConversionException("Unit conversion is non-linear");
                    }
                    double d = unitConverter.convert(1.0) - unitConverter.convert(0.0);
                    if (Math.abs(d) <= 1.0) continue;
                }
                unit = unit2;
            }
            this.distanceUnit = unit;
        }
        return unit;
    }

    final void ensureDimensionMatch(String string, double[] dArray) throws MismatchedDimensionException {
        if (dArray.length != this.axis.length) {
            throw new MismatchedDimensionException(Errors.format(94, string, dArray.length, this.axis.length));
        }
    }

    public Measure distance(double[] dArray, double[] dArray2) throws UnsupportedOperationException, MismatchedDimensionException {
        throw new UnsupportedOperationException();
    }

    private static DefaultCoordinateSystemAxis[] getDefaultAxis(CoordinateSystem coordinateSystem) {
        DefaultCoordinateSystemAxis[] defaultCoordinateSystemAxisArray = new DefaultCoordinateSystemAxis[coordinateSystem.getDimension()];
        for (int i = 0; i < defaultCoordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.getPredefined(coordinateSystemAxis);
            if (defaultCoordinateSystemAxis == null) {
                defaultCoordinateSystemAxis = coordinateSystemAxis instanceof DefaultCoordinateSystemAxis ? (DefaultCoordinateSystemAxis)coordinateSystemAxis : new DefaultCoordinateSystemAxis(coordinateSystemAxis);
            }
            defaultCoordinateSystemAxisArray[i] = defaultCoordinateSystemAxis;
        }
        return defaultCoordinateSystemAxisArray;
    }

    final boolean axisColinearWith(CoordinateSystem coordinateSystem) {
        if (coordinateSystem.getDimension() != this.getDimension()) {
            return false;
        }
        DefaultCoordinateSystemAxis[] defaultCoordinateSystemAxisArray = AbstractCS.getDefaultAxis(this);
        DefaultCoordinateSystemAxis[] defaultCoordinateSystemAxisArray2 = AbstractCS.getDefaultAxis(coordinateSystem);
        for (int i = 0; i < defaultCoordinateSystemAxisArray.length; ++i) {
            block5: {
                DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = defaultCoordinateSystemAxisArray[i];
                DefaultCoordinateSystemAxis defaultCoordinateSystemAxis2 = defaultCoordinateSystemAxis.getOpposite();
                for (int j = 0; j < defaultCoordinateSystemAxisArray2.length; ++j) {
                    DefaultCoordinateSystemAxis defaultCoordinateSystemAxis3 = defaultCoordinateSystemAxisArray2[j];
                    if (defaultCoordinateSystemAxis3 == null || !defaultCoordinateSystemAxis3.equals(defaultCoordinateSystemAxis, false, false) && (defaultCoordinateSystemAxis2 == null || !defaultCoordinateSystemAxis3.equals(defaultCoordinateSystemAxis2, false, false))) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            defaultCoordinateSystemAxisArray2[j] = null;
        }
        assert (this.directionColinearWith(coordinateSystem));
        return true;
    }

    final boolean directionColinearWith(CoordinateSystem coordinateSystem) {
        int n;
        if (coordinateSystem.getDimension() != this.axis.length) {
            return false;
        }
        AxisDirection[] axisDirectionArray = new AxisDirection[this.axis.length];
        for (n = 0; n < axisDirectionArray.length; ++n) {
            axisDirectionArray[n] = coordinateSystem.getAxis(n).getDirection().absolute();
        }
        for (n = 0; n < this.axis.length; ++n) {
            block5: {
                AxisDirection axisDirection = this.axis[n].getDirection().absolute();
                for (int i = 0; i < axisDirectionArray.length; ++i) {
                    AxisDirection axisDirection2 = axisDirectionArray[i];
                    if (axisDirection2 == null || !axisDirection2.equals(axisDirection)) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            axisDirectionArray[i] = null;
        }
        return true;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            AbstractCS abstractCS = (AbstractCS)abstractIdentifiedObject;
            return AbstractCS.equals(this.axis, abstractCS.axis, bl);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1480995944;
        for (int i = 0; i < this.axis.length; ++i) {
            n = n * 37 + this.axis[i].hashCode();
        }
        return n;
    }
}

