/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.cs.DefaultCompoundCS;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedCollection;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;

public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929286L;
    private final List<? extends CoordinateReferenceSystem> crs;
    private transient List<SingleCRS> singles;

    public DefaultCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        super(map, DefaultCompoundCRS.createCoordinateSystem(coordinateReferenceSystemArray));
        this.crs = this.copy(Arrays.asList(coordinateReferenceSystemArray));
    }

    private static CoordinateSystem createCoordinateSystem(CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        DefaultCompoundCRS.ensureNonNull("crs", coordinateReferenceSystemArray);
        if (coordinateReferenceSystemArray.length < 2) {
            throw new IllegalArgumentException(Errors.format(99, "crs[" + coordinateReferenceSystemArray.length + ']'));
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[coordinateReferenceSystemArray.length];
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            DefaultCompoundCRS.ensureNonNull("crs", coordinateReferenceSystemArray, i);
            coordinateSystemArray[i] = coordinateReferenceSystemArray[i].getCoordinateSystem();
        }
        return new DefaultCompoundCS(coordinateSystemArray);
    }

    private List<? extends CoordinateReferenceSystem> copy(List<? extends CoordinateReferenceSystem> list) {
        list = this.computeSingleCRS(list) ? this.singles : UnmodifiableArrayList.wrap(list.toArray(new CoordinateReferenceSystem[list.size()]));
        return list;
    }

    @Override
    public List<CoordinateReferenceSystem> getCoordinateReferenceSystems() {
        return this.crs;
    }

    public List<SingleCRS> getSingleCRS() {
        return this.singles;
    }

    public static List<SingleCRS> getSingleCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<SingleCRS> list;
        if (coordinateReferenceSystem instanceof DefaultCompoundCRS) {
            list = ((DefaultCompoundCRS)coordinateReferenceSystem).getSingleCRS();
        } else if (coordinateReferenceSystem instanceof CompoundCRS) {
            List<CoordinateReferenceSystem> list2 = ((CompoundCRS)coordinateReferenceSystem).getCoordinateReferenceSystems();
            list = new ArrayList<SingleCRS>(list2.size());
            DefaultCompoundCRS.getSingleCRS(list2, list);
        } else {
            list = Collections.singletonList((SingleCRS)coordinateReferenceSystem);
        }
        return list;
    }

    private static boolean getSingleCRS(List<? extends CoordinateReferenceSystem> list, List<SingleCRS> list2) {
        boolean bl = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : list) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                DefaultCompoundCRS.getSingleCRS(((CompoundCRS)coordinateReferenceSystem).getCoordinateReferenceSystems(), list2);
                bl = false;
                continue;
            }
            list2.add((SingleCRS)coordinateReferenceSystem);
        }
        return bl;
    }

    private boolean computeSingleCRS(List<? extends CoordinateReferenceSystem> list) {
        this.singles = new ArrayList<SingleCRS>(list.size());
        boolean bl = DefaultCompoundCRS.getSingleCRS(list, this.singles);
        this.singles = UnmodifiableArrayList.wrap(this.singles.toArray(new SingleCRS[this.singles.size()]));
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        objectInputStream.defaultReadObject();
        if (this.crs instanceof CheckedCollection && SingleCRS.class.isAssignableFrom(clazz = ((CheckedCollection)((Object)this.crs)).getElementType())) {
            this.singles = this.crs;
            return;
        }
        this.computeSingleCRS(this.crs);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)abstractIdentifiedObject;
            return DefaultCompoundCRS.equals(this.crs, defaultCompoundCRS.crs, bl);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.crs.hashCode() ^ 0x73EE077A;
    }
}

