/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public abstract class FunctionExpressionImpl
extends DefaultExpression
implements FunctionExpression {
    protected String name;
    protected List params;
    protected Literal fallback;

    protected FunctionExpressionImpl(String string) {
        this(string, null);
    }

    protected FunctionExpressionImpl(String string, Literal literal) {
        this.name = string;
        this.fallback = literal;
        this.params = new ArrayList();
    }

    @Override
    public short getType() {
        return 114;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(List list) {
        if (list == null) {
            throw new NullPointerException("params can't be null");
        }
        int n = this.getArgCount();
        int n2 = list.size();
        if (n > 0 && n != n2) {
            throw new IllegalArgumentException("Function " + this.name + " expected " + n + " arguments, got " + n2);
        }
        this.params = new ArrayList(list);
    }

    @Override
    public abstract int getArgCount();

    @Override
    public Object accept(ExpressionVisitor expressionVisitor, Object object) {
        return expressionVisitor.visit(this, object);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        List list = this.getParameters();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                stringBuffer.append("[");
                stringBuffer.append(expression);
                stringBuffer.append("]");
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Function)) {
            return false;
        }
        Function function = (Function)object;
        if (this.getName() == null && function.getName() != null || this.getName() != null && !this.getName().equalsIgnoreCase(function.getName())) {
            return false;
        }
        if (this.getParameters() == null && function.getClass() != null) {
            return false;
        }
        return this.getParameters() != null && this.getParameters().equals(function.getParameters());
    }
}

