/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.geotools.factory.Hints;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public final class GeoTools {
    private static final EventListenerList LISTENERS = new EventListenerList();
    private static final Map<String, RenderingHints.Key> BINDINGS = new HashMap<String, RenderingHints.Key>();
    public static final String CRS_AUTHORITY_EXTRA_DIRECTORY = "org.geotools.referencing.crs-directory";
    public static final String EPSG_DATA_SOURCE = "org.geotools.referencing.epsg-datasource";
    public static final String FORCE_LONGITUDE_FIRST_AXIS_ORDER = "org.geotools.referencing.forceXY";
    public static final String RESAMPLE_TOLERANCE = "org.geotools.referencing.resampleTolerance";

    private GeoTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind(String string, RenderingHints.Key key) {
        Map<String, RenderingHints.Key> map = BINDINGS;
        synchronized (map) {
            RenderingHints.Key key2 = BINDINGS.put(string, key);
            if (key2 == null) {
                return;
            }
            BINDINGS.put(string, key2);
        }
        throw new IllegalArgumentException(Errors.format(58, "property", string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean scanForSystemHints(Hints hints) {
        assert (Thread.holdsLock(hints));
        boolean bl = false;
        Map<String, RenderingHints.Key> map = BINDINGS;
        synchronized (map) {
            for (Map.Entry<String, RenderingHints.Key> entry : BINDINGS.entrySet()) {
                Class<?> clazz;
                String string;
                String string2 = entry.getKey();
                try {
                    string = System.getProperty(string2);
                }
                catch (SecurityException securityException) {
                    GeoTools.unexpectedException(securityException);
                    continue;
                }
                if (string == null) continue;
                Object object = string;
                RenderingHints.Key key = entry.getValue();
                if (key.getClass().equals(Hints.Key.class)) {
                    clazz = ((Hints.Key)key).getValueClass();
                    if (clazz.equals(Boolean.class)) {
                        object = Boolean.valueOf(string);
                    } else if (Number.class.isAssignableFrom(clazz)) {
                        try {
                            object = Classes.valueOf(clazz, string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            GeoTools.unexpectedException(numberFormatException);
                            continue;
                        }
                    }
                }
                try {
                    clazz = hints.put(key, object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    GeoTools.unexpectedException(illegalArgumentException);
                    continue;
                }
                if (bl || Utilities.equals(clazz, object)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(Hints.class, "scanSystemProperties", exception);
    }

    public static Hints getDefaultHints() {
        return Hints.getDefaults(false);
    }

    public static void addChangeListener(ChangeListener changeListener) {
        GeoTools.removeChangeListener(changeListener);
        LISTENERS.add(ChangeListener.class, changeListener);
    }

    public static void removeChangeListener(ChangeListener changeListener) {
        LISTENERS.remove(ChangeListener.class, changeListener);
    }

    public static void fireConfigurationChanged() {
        ChangeEvent changeEvent = new ChangeEvent(GeoTools.class);
        Object[] objectArray = LISTENERS.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    static {
        GeoTools.bind(CRS_AUTHORITY_EXTRA_DIRECTORY, Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        GeoTools.bind(EPSG_DATA_SOURCE, Hints.EPSG_DATA_SOURCE);
        GeoTools.bind(FORCE_LONGITUDE_FIRST_AXIS_ORDER, Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        GeoTools.bind(RESAMPLE_TOLERANCE, Hints.RESAMPLE_TOLERANCE);
    }
}

