/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.resources.NIOUtilities;

public class DbaseFileReader
implements FileReader {
    DbaseFileHeader header;
    ByteBuffer buffer;
    ReadableByteChannel channel;
    byte[] bytes;
    char[] fieldTypes;
    int[] fieldLengths;
    int[] fieldOffsets;
    int cnt = 1;
    Row row;
    protected boolean useMemoryMappedBuffer;
    protected boolean randomAccessEnabled;
    protected long currentOffset = 0L;
    private final StreamLogging streamLogger = new StreamLogging("Dbase File Reader");
    private Charset stringCharset;
    private boolean oneBytePerChar;
    private Calendar calendar;
    private final long MILLISECS_PER_DAY = 86400000L;

    public DbaseFileReader(ShpFiles shpFiles, boolean bl, Charset charset, TimeZone timeZone) throws IOException {
        ReadableByteChannel readableByteChannel = shpFiles.getReadChannel(ShpFileType.DBF, this);
        this.init(readableByteChannel, bl, charset, timeZone);
    }

    private void init(ReadableByteChannel readableByteChannel, boolean bl, Charset charset, TimeZone timeZone) throws IOException {
        this.channel = readableByteChannel;
        this.stringCharset = charset == null ? Charset.defaultCharset() : charset;
        TimeZone timeZone2 = timeZone == null ? TimeZone.getDefault() : timeZone;
        this.calendar = Calendar.getInstance(timeZone2, Locale.US);
        this.useMemoryMappedBuffer = bl;
        this.randomAccessEnabled = this.channel instanceof FileChannel;
        this.streamLogger.open();
        this.header = new DbaseFileHeader();
        if (this.channel instanceof FileChannel && this.useMemoryMappedBuffer) {
            FileChannel fileChannel = (FileChannel)this.channel;
            this.buffer = fileChannel.size() - fileChannel.position() < Integer.MAX_VALUE ? fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()) : fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, Integer.MAX_VALUE);
            this.buffer.position((int)fileChannel.position());
            this.header.readHeader(this.buffer);
            this.currentOffset = 0L;
        } else {
            this.useMemoryMappedBuffer = false;
            this.header.readHeader(this.channel, charset);
            this.buffer = NIOUtilities.allocate(this.header.getRecordLength());
            this.fill(this.buffer, this.channel);
            this.buffer.flip();
            this.currentOffset = this.header.getHeaderLength();
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fieldTypes = new char[this.header.getNumFields()];
        this.fieldLengths = new int[this.header.getNumFields()];
        this.fieldOffsets = new int[this.header.getNumFields()];
        int n = this.header.getNumFields();
        for (int i = 0; i < n; ++i) {
            this.fieldTypes[i] = this.header.getFieldType(i);
            this.fieldLengths[i] = this.header.getFieldLength(i);
            if (i <= 0) continue;
            this.fieldOffsets[i] = this.fieldOffsets[i - 1] + this.header.getFieldLength(i - 1);
        }
        this.bytes = new byte[this.header.getRecordLength() - 1];
        String string = this.stringCharset.name();
        this.oneBytePerChar = "ISO-8859-1".equals(string) || "US-ASCII".equals(string);
        this.row = new Row();
    }

    protected int fill(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel) throws IOException {
        int n = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0 && n != -1) {
            n = readableByteChannel.read(byteBuffer);
        }
        if (n == -1) {
            byteBuffer.limit(byteBuffer.position());
        }
        return n;
    }

    private void bufferCheck() throws IOException {
        if (this.useMemoryMappedBuffer) {
            if (this.buffer.remaining() < this.header.getRecordLength()) {
                FileChannel fileChannel = (FileChannel)this.channel;
                int n = this.buffer.position();
                this.currentOffset = fileChannel.size() > (long)(n + Integer.MAX_VALUE) ? (long)n : fileChannel.size() - Integer.MAX_VALUE;
                NIOUtilities.clean(this.buffer);
                this.buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.currentOffset, Integer.MAX_VALUE);
                this.buffer = ((FileChannel)this.channel).map(FileChannel.MapMode.READ_ONLY, this.buffer.position(), Integer.MAX_VALUE);
            }
        } else if (this.buffer.remaining() < this.header.getRecordLength()) {
            this.currentOffset += (long)this.buffer.position();
            this.buffer.compact();
            this.fill(this.buffer, this.channel);
            this.buffer.position(0);
        }
    }

    public DbaseFileHeader getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
        if (this.buffer != null) {
            NIOUtilities.clean(this.buffer, this.useMemoryMappedBuffer);
        }
        this.buffer = null;
        this.channel = null;
        this.bytes = null;
        this.header = null;
        this.row = null;
    }

    public boolean hasNext() {
        return this.cnt < this.header.getNumRecords() + 1;
    }

    public Row readRow() throws IOException {
        this.read();
        return this.row;
    }

    public void skip() throws IOException {
        boolean bl = false;
        while (!bl) {
            this.bufferCheck();
            char c = (char)this.buffer.get();
            this.buffer.position(this.buffer.position() + this.header.getRecordLength() - 1);
            if (c == '*') continue;
            bl = true;
        }
        ++this.cnt;
    }

    public void read() throws IOException {
        boolean bl = false;
        while (!bl) {
            this.bufferCheck();
            char c = (char)this.buffer.get();
            if (c == '*') continue;
            this.buffer.limit(this.buffer.position() + this.header.getRecordLength() - 1);
            this.buffer.get(this.bytes);
            this.buffer.limit(this.buffer.capacity());
            bl = true;
        }
        ++this.cnt;
    }

    private Object readObject(int n, int n2) throws IOException {
        char c = this.fieldTypes[n2];
        int n3 = this.fieldLengths[n2];
        Object object = null;
        if (n3 > 0) {
            block5 : switch (c) {
                case 'L': 
                case 'l': {
                    char c2 = (char)this.bytes[n];
                    switch (c2) {
                        case 'T': 
                        case 'Y': 
                        case 't': 
                        case 'y': {
                            object = Boolean.TRUE;
                            break block5;
                        }
                        case 'F': 
                        case 'N': 
                        case 'f': 
                        case 'n': {
                            object = Boolean.FALSE;
                            break block5;
                        }
                    }
                    break;
                }
                case 'C': 
                case 'c': {
                    if (this.bytes[n] == 0) break;
                    if (this.oneBytePerChar) {
                        object = this.fastParse(this.bytes, n, n3).trim();
                        break;
                    }
                    object = new String(this.bytes, n, n3, this.stringCharset.name()).trim();
                    break;
                }
                case 'D': 
                case 'd': {
                    for (int i = 0; i < 8; ++i) {
                        if (this.bytes[n + i] == 48) continue;
                        try {
                            String string = this.fastParse(this.bytes, n, 4);
                            int n4 = Integer.parseInt(string);
                            string = this.fastParse(this.bytes, n + 4, 2);
                            int n5 = Integer.parseInt(string) - 1;
                            string = this.fastParse(this.bytes, n + 6, 2);
                            int n6 = Integer.parseInt(string);
                            this.calendar.clear();
                            this.calendar.set(1, n4);
                            this.calendar.set(2, n5);
                            this.calendar.set(5, n6);
                            object = this.calendar.getTime();
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break block5;
                    }
                    break;
                }
                case '@': {
                    try {
                        byte[] byArray = new byte[]{this.bytes[n + 7], this.bytes[n + 6], this.bytes[n + 5], this.bytes[n + 4], this.bytes[n + 3], this.bytes[n + 2], this.bytes[n + 1], this.bytes[n]};
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(byteArrayInputStream));
                        int n7 = dataInputStream.readInt();
                        int n8 = dataInputStream.readInt();
                        this.calendar.setTimeInMillis((long)n8 * 86400000L + DbaseFileHeader.MILLIS_SINCE_4713 + (long)n7);
                        object = this.calendar.getTime();
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case 'N': 
                case 'n': {
                    if (this.bytes[n] == 42) break;
                    String string = this.fastParse(this.bytes, n, n3).trim();
                    Class<Long> clazz = this.header.getFieldClass(n2);
                    if (clazz == Integer.class) {
                        try {
                            object = Integer.parseInt(string);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            clazz = Long.class;
                        }
                    }
                    if (clazz == Long.class) {
                        try {
                            object = Long.parseLong(string);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                case 'F': 
                case 'f': {
                    if (this.bytes[n] == 42) break;
                    try {
                        object = Double.parseDouble(this.fastParse(this.bytes, n, n3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = new Double(0.0);
                    }
                    break;
                }
                default: {
                    throw new IOException("Invalid field type : " + c);
                }
            }
        }
        return object;
    }

    String fastParse(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)(0xFF & byArray[n + i]);
        }
        return new String(cArray);
    }

    public final class Row {
        public Object read(int n) throws IOException {
            int n2 = DbaseFileReader.this.fieldOffsets[n];
            return DbaseFileReader.this.readObject(n2, n);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("DBF Row - ");
            for (int i = 0; i < DbaseFileReader.this.header.getNumFields(); ++i) {
                stringBuffer.append(DbaseFileReader.this.header.getFieldName(i)).append(": \"");
                try {
                    stringBuffer.append(this.read(i));
                }
                catch (IOException iOException) {
                    stringBuffer.append(iOException.getMessage());
                }
                stringBuffer.append("\" ");
            }
            return stringBuffer.toString();
        }
    }
}

