/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShpFiles;

public class FileChannelDecorator
extends FileChannel {
    private final FileChannel wrapped;
    private final ShpFiles shapefileFiles;
    private final URL url;
    private final FileReader reader;
    private final FileWriter writer;
    private boolean closed;

    public FileChannelDecorator(FileChannel fileChannel, ShpFiles shpFiles, URL uRL, FileReader fileReader) {
        this.wrapped = fileChannel;
        this.shapefileFiles = shpFiles;
        this.url = uRL;
        this.reader = fileReader;
        this.writer = null;
        this.closed = false;
    }

    @Override
    public void force(boolean bl) throws IOException {
        this.wrapped.force(bl);
    }

    @Override
    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        return this.wrapped.lock(l, l2, bl);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        return this.shapefileFiles.map(this.wrapped, this.url, mapMode, l, l2);
    }

    @Override
    public long position() throws IOException {
        return this.wrapped.position();
    }

    @Override
    public FileChannel position(long l) throws IOException {
        return this.wrapped.position(l);
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return this.wrapped.read(byteBuffer, l);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.wrapped.read(byteBuffer);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.wrapped.read(byteBufferArray, n, n2);
    }

    @Override
    public long size() throws IOException {
        return this.wrapped.size();
    }

    @Override
    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        return this.wrapped.transferFrom(readableByteChannel, l, l2);
    }

    @Override
    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        return this.wrapped.transferTo(l, l2, writableByteChannel);
    }

    @Override
    public FileChannel truncate(long l) throws IOException {
        return this.wrapped.truncate(l);
    }

    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return this.wrapped.tryLock(l, l2, bl);
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        return this.wrapped.write(byteBuffer, l);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.wrapped.write(byteBuffer);
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.wrapped.write(byteBufferArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        try {
            this.wrapped.close();
        }
        finally {
            if (!this.closed) {
                this.closed = true;
                if (this.reader != null) {
                    this.shapefileFiles.unlockRead(this.url, this.reader);
                } else {
                    this.shapefileFiles.unlockWrite(this.url, this.writer);
                }
            }
        }
    }
}

