/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.directory.DirectoryFeatureLocking;
import org.geotools.data.directory.DirectoryFeatureSource;
import org.geotools.data.directory.DirectoryFeatureStore;
import org.geotools.data.directory.DirectoryLockingManager;
import org.geotools.data.directory.DirectoryTypeCache;
import org.geotools.data.directory.FileStoreFactory;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class DirectoryDataStore
implements DataStore {
    DirectoryTypeCache cache;
    DirectoryLockingManager lm;

    public DirectoryDataStore(File file, FileStoreFactory fileStoreFactory) throws IOException {
        this.cache = new DirectoryTypeCache(file, fileStoreFactory);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        String string = query.getTypeName();
        return this.getDataStore(string).getFeatureReader(query, transaction);
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String string) throws IOException {
        SimpleFeatureSource simpleFeatureSource = this.getDataStore(string).getFeatureSource(string);
        if (simpleFeatureSource instanceof SimpleFeatureLocking) {
            return new DirectoryFeatureLocking((SimpleFeatureLocking)simpleFeatureSource);
        }
        if (simpleFeatureSource instanceof FeatureStore) {
            return new DirectoryFeatureStore((SimpleFeatureStore)simpleFeatureSource);
        }
        return new DirectoryFeatureSource(simpleFeatureSource);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Filter filter, Transaction transaction) throws IOException {
        return this.getDataStore(string).getFeatureWriter(string, filter, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Transaction transaction) throws IOException {
        return this.getDataStore(string).getFeatureWriter(string, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String string, Transaction transaction) throws IOException {
        return this.getDataStore(string).getFeatureWriterAppend(string, transaction);
    }

    @Override
    public LockingManager getLockingManager() {
        if (this.lm == null) {
            this.lm = new DirectoryLockingManager(this.cache);
        }
        return this.lm;
    }

    @Override
    public SimpleFeatureType getSchema(String string) throws IOException {
        return this.getDataStore(string).getSchema(string);
    }

    @Override
    public String[] getTypeNames() throws IOException {
        Set<String> set = this.cache.getTypeNames();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public void updateSchema(String string, SimpleFeatureType simpleFeatureType) throws IOException {
        this.getDataStore(string).updateSchema(string, simpleFeatureType);
    }

    @Override
    public void createSchema(SimpleFeatureType simpleFeatureType) throws IOException {
        File file = new File(this.cache.directory, simpleFeatureType.getTypeName() + ".shp");
        String string = "org.geotools.data.shapefile.ShapefileDataStore";
        DataStore dataStore = null;
        try {
            dataStore = (DataStore)Class.forName(string).getConstructor(URL.class).newInstance(file.toURL());
            dataStore.createSchema(simpleFeatureType);
            dataStore.dispose();
            this.cache.refreshCacheContents();
        }
        catch (Exception exception) {
            throw (IOException)new IOException("Error creating new data store").initCause(exception);
        }
    }

    @Override
    public void dispose() {
        this.cache.dispose();
    }

    public DataStore getDataStore(String string) throws IOException {
        DataStore dataStore = this.cache.getDataStore(string, true);
        if (dataStore == null) {
            throw new IOException("Feature type " + string + " is unknown");
        }
        return dataStore;
    }
}

