/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class FilteringFeatureReader<T extends FeatureType, F extends Feature>
implements DelegatingFeatureReader<T, F> {
    protected final FeatureReader<T, F> featureReader;
    protected final Filter filter;
    protected F next;

    public FilteringFeatureReader(FeatureReader<T, F> featureReader, Filter filter) {
        this.featureReader = featureReader;
        this.filter = filter;
        this.next = null;
    }

    @Override
    public F next() throws IOException, IllegalAttributeException, NoSuchElementException {
        F f = null;
        if (this.hasNext()) {
            f = this.next;
            this.next = null;
            return f;
        }
        throw new NoSuchElementException("No such Feature exsists");
    }

    @Override
    public void close() throws IOException {
        this.featureReader.close();
    }

    @Override
    public T getFeatureType() {
        return this.featureReader.getFeatureType();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        try {
            while (this.featureReader.hasNext()) {
                F f = this.featureReader.next();
                if (!this.filter.evaluate(f)) continue;
                this.next = f;
                return true;
            }
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new DataSourceException("Could not peek ahead", illegalAttributeException);
        }
        return this.next != null;
    }
}

