/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.licensechange;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.licensechange.Check;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangePlugin;
import org.openstreetmap.josm.plugins.licensechange.LicenseProblem;
import org.openstreetmap.josm.plugins.licensechange.Severity;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLicenseCheck
extends Check {
    private LicenseChangePlugin plugin;

    public BasicLicenseCheck(LicenseChangePlugin p) {
        super(I18n.tr((String)"Basic License Check.", (Object[])new Object[0]), I18n.tr((String)"Checks if all contributors have agreed to the new CT/License.", (Object[])new Object[0]));
        this.plugin = p;
    }

    @Override
    public void visit(Node n) {
        HashMap<User, Severity> users = this.plugin.getUsers(n);
        this.doCheck((OsmPrimitive)n, users);
    }

    @Override
    public void visit(Way w) {
        HashMap<User, Severity> users = this.plugin.getUsers(w);
        this.doCheck((OsmPrimitive)w, users);
    }

    @Override
    public void visit(Relation r) {
        HashMap<User, Severity> users = this.plugin.getUsers(r);
        this.doCheck((OsmPrimitive)r, users);
    }

    private void doCheck(OsmPrimitive n, HashMap<User, Severity> users) {
        Severity sev = null;
        if (users != null) {
            for (Map.Entry<User, Severity> e : users.entrySet()) {
                if (sev != null && sev.compareTo((Enum)e.getValue()) <= 0) continue;
                sev = e.getValue();
            }
            String msg = null;
            msg = sev == Severity.FIRST ? I18n.tr((String)"Creator has not agreed to CT", (Object[])new Object[0]) : (sev == Severity.NORMAL ? I18n.tr((String)"Object modified by user(s) who have rejected, or not agreed to, CT", (Object[])new Object[0]) : I18n.tr((String)"minor issue", (Object[])new Object[0]));
            if (sev != null) {
                List<OsmPrimitive> x = Arrays.asList(n);
                this.errors.add(new LicenseProblem(this, sev, msg, x, x));
            }
        }
    }
}

