/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Collection;
import java.util.Iterator;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

public final class Citations {
    public static final Citation OGC;
    public static final Citation OPEN_GIS;
    public static final Citation ESRI;
    public static final Citation ORACLE;
    public static final Citation GEOTOOLS;
    public static final Citation WMS;
    public static final Citation GEOTIFF;
    public static final Citation JAI;
    public static final Citation EPSG;
    public static final Citation AUTO;
    public static final Citation AUTO2;
    public static final Citation CRS;
    private static final Citation[] AUTHORITIES;

    private Citations() {
    }

    public static Citation fromName(String string) {
        for (int i = 0; i < AUTHORITIES.length; ++i) {
            Citation citation = AUTHORITIES[i];
            if (!Citations.titleMatches(citation, string)) continue;
            return citation;
        }
        return new CitationImpl(string);
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        InternationalString internationalString = citation2.getTitle();
        Iterator<? extends InternationalString> iterator = null;
        while (true) {
            String string;
            if (Citations.titleMatches(citation, string = internationalString.toString(null))) {
                return true;
            }
            String string2 = internationalString.toString();
            if (string2 != string && Citations.titleMatches(citation, string2)) {
                return true;
            }
            if (iterator == null) {
                Collection<? extends InternationalString> collection = citation2.getAlternateTitles();
                if (collection == null) break;
                iterator = collection.iterator();
            }
            if (!iterator.hasNext()) break;
            internationalString = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, String string) {
        string = string.trim();
        InternationalString internationalString = citation.getTitle();
        Iterator<? extends InternationalString> iterator = null;
        while (true) {
            String string2;
            if ((string2 = internationalString.toString(null)).trim().equalsIgnoreCase(string)) {
                return true;
            }
            String string3 = internationalString.toString();
            if (string3 != string2 && string3.trim().equalsIgnoreCase(string)) {
                return true;
            }
            if (iterator == null) {
                Collection<? extends InternationalString> collection = citation.getAlternateTitles();
                if (collection == null) break;
                iterator = collection.iterator();
            }
            if (!iterator.hasNext()) break;
            internationalString = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        Iterator<? extends Identifier> iterator = citation2.getIdentifiers().iterator();
        if (!iterator.hasNext()) {
            iterator = citation.getIdentifiers().iterator();
            if (!iterator.hasNext()) {
                return Citations.titleMatches(citation, citation2);
            }
            citation = citation2;
            citation2 = null;
        }
        do {
            String string;
            if (!Citations.identifierMatches(citation, string = iterator.next().getCode().trim())) continue;
            return true;
        } while (iterator.hasNext());
        return false;
    }

    public static boolean identifierMatches(Citation citation, String string) {
        string = string.trim();
        Collection<? extends Identifier> collection = citation.getIdentifiers();
        for (Identifier identifier : collection) {
            String string2 = identifier.getCode().trim();
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        if (collection.isEmpty()) {
            return Citations.titleMatches(citation, string);
        }
        return false;
    }

    public static String getIdentifier(Citation citation) {
        String string = null;
        for (Identifier identifier : citation.getIdentifiers()) {
            String string2 = identifier.getCode().trim();
            int n = string2.length();
            if (n == 0 || string != null && n >= string.length()) continue;
            string = string2;
        }
        if (string == null) {
            string = String.valueOf(citation.getTitle());
        }
        return string;
    }

    static {
        CitationImpl citationImpl = new CitationImpl(ResponsiblePartyImpl.OGC);
        citationImpl.getAlternateTitles().add(new SimpleInternationalString("OGC"));
        citationImpl.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        citationImpl.freeze();
        OGC = citationImpl;
        citationImpl = new CitationImpl(ResponsiblePartyImpl.OPEN_GIS);
        Collection<Object> collection = citationImpl.getAlternateTitles();
        collection.add(new SimpleInternationalString("OpenGIS"));
        collection.addAll(OGC.getAlternateTitles());
        citationImpl.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        citationImpl.freeze();
        OPEN_GIS = citationImpl;
        citationImpl = new CitationImpl(ResponsiblePartyImpl.ESRI);
        citationImpl.addAuthority("ESRI", true);
        citationImpl.freeze();
        ESRI = citationImpl;
        citationImpl = new CitationImpl(ResponsiblePartyImpl.ORACLE);
        citationImpl.freeze();
        ORACLE = citationImpl;
        citationImpl = new CitationImpl(ResponsiblePartyImpl.GEOTOOLS);
        citationImpl.freeze();
        GEOTOOLS = citationImpl;
        citationImpl = new CitationImpl("Web Map Service");
        collection = citationImpl.getAlternateTitles();
        collection.add(new SimpleInternationalString("WMS"));
        collection.add(new SimpleInternationalString("WMS 1.3.0"));
        collection.add(new SimpleInternationalString("OGC 04-024"));
        collection.add(new SimpleInternationalString("ISO 19128"));
        Collection<ResponsibleParty> collection2 = citationImpl.getCitedResponsibleParties();
        collection2.add(ResponsiblePartyImpl.OGC);
        collection2.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineResourceImpl.WMS));
        citationImpl.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        citationImpl.freeze();
        WMS = citationImpl;
        citationImpl = new CitationImpl(ResponsiblePartyImpl.GEOTIFF);
        citationImpl.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        citationImpl.freeze();
        GEOTIFF = citationImpl;
        citationImpl = new CitationImpl("Java Advanced Imaging");
        citationImpl.getAlternateTitles().add(new SimpleInternationalString("JAI"));
        citationImpl.getCitedResponsibleParties().add(ResponsiblePartyImpl.SUN_MICROSYSTEMS);
        citationImpl.freeze();
        JAI = citationImpl;
        citationImpl = new CitationImpl(ResponsiblePartyImpl.EPSG);
        citationImpl.addAuthority("EPSG", true);
        citationImpl.getPresentationForm().add(PresentationForm.TABLE_DIGITAL);
        citationImpl.freeze();
        EPSG = citationImpl;
        citationImpl = new CitationImpl("Automatic Projections");
        citationImpl.addAuthority("AUTO", false);
        collection = citationImpl.getCitedResponsibleParties();
        collection.add((InternationalString)((Object)ResponsiblePartyImpl.OGC));
        collection.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineFunction.DOWNLOAD, "http://www.opengis.org/docs/01-068r3.pdf"));
        citationImpl.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        citationImpl.freeze();
        AUTO = citationImpl;
        citationImpl = new CitationImpl("Automatic Projections");
        citationImpl.addAuthority("AUTO2", false);
        collection = citationImpl.getCitedResponsibleParties();
        collection.add(ResponsiblePartyImpl.OGC);
        collection.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineResourceImpl.WMS));
        citationImpl.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        citationImpl.freeze();
        AUTO2 = citationImpl;
        citationImpl = new CitationImpl("Web Map Service CRS");
        citationImpl.addAuthority("CRS", false);
        citationImpl.getCitedResponsibleParties().addAll(AUTO2.getCitedResponsibleParties());
        citationImpl.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        citationImpl.freeze();
        CRS = citationImpl;
        AUTHORITIES = new Citation[]{OGC, OPEN_GIS, ESRI, ORACLE, GEOTOOLS, WMS, GEOTIFF, JAI, EPSG, AUTO, AUTO2, CRS};
    }
}

