/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;

public final class MultiplyConverter
extends UnitConverter {
    private final double _factor;
    private static final long serialVersionUID = 1L;

    public MultiplyConverter(double d) {
        if ((double)((float)d) == 1.0) {
            throw new IllegalArgumentException("Identity converter not allowed");
        }
        this._factor = d;
    }

    @Override
    public UnitConverter inverse() {
        return new MultiplyConverter(1.0 / this._factor);
    }

    @Override
    public double convert(double d) {
        return this._factor * d;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public UnitConverter concatenate(UnitConverter unitConverter) {
        if (unitConverter instanceof MultiplyConverter) {
            double d = this._factor * ((MultiplyConverter)unitConverter)._factor;
            return MultiplyConverter.valueOf(d);
        }
        if (unitConverter instanceof RationalConverter) {
            double d = this._factor * (double)((RationalConverter)unitConverter).getDividend() / (double)((RationalConverter)unitConverter).getDivisor();
            return MultiplyConverter.valueOf(d);
        }
        return super.concatenate(unitConverter);
    }

    private static UnitConverter valueOf(double d) {
        float f = (float)d;
        return f == 1.0f ? UnitConverter.IDENTITY : new MultiplyConverter(d);
    }
}

