/*
 * Decompiled with CFR 0.152.
 */
package mergeoverlap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import mergeoverlap.MergeOverlapAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueCellEditor;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverColumnModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverColumnModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCombinePrimitiveResolverDialog
extends JDialog {
    private static MyCombinePrimitiveResolverDialog instance;
    private AutoAdjustingSplitPane spTagConflictTypes;
    private MyTagConflictResolver pnlTagConflictResolver;
    private MyRelationMemberConflictResolver pnlRelationMemberConflictResolver;
    private boolean cancelled;
    private JPanel pnlButtons;
    private OsmPrimitive targetPrimitive;
    private ContextSensitiveHelpAction helpAction;
    private SideButton btnApply;

    public static MyCombinePrimitiveResolverDialog getInstance() {
        if (instance == null) {
            instance = new MyCombinePrimitiveResolverDialog(Main.parent);
        }
        return instance;
    }

    public OsmPrimitive getTargetPrimitmive() {
        return this.targetPrimitive;
    }

    public void setTargetPrimitive(OsmPrimitive primitive) {
        this.targetPrimitive = primitive;
        this.updateTitle();
        if (primitive instanceof Way) {
            this.pnlRelationMemberConflictResolver.initForWayCombining();
        } else if (primitive instanceof Node) {
            this.pnlRelationMemberConflictResolver.initForNodeMerging();
        }
    }

    protected void updateTitle() {
        if (this.targetPrimitive == null) {
            this.setTitle(I18n.tr((String)"Conflicts when combining primitives", null));
            return;
        }
        if (this.targetPrimitive instanceof Way) {
            this.setTitle(I18n.tr((String)"Conflicts when combining ways - combined way is ''{0}''", (Object[])new Object[]{this.targetPrimitive.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}));
            this.helpAction.setHelpTopic(HelpUtil.ht((String)"/Action/CombineWay#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht((String)"/Action/CombineWay#ResolvingConflicts"));
        } else if (this.targetPrimitive instanceof Node) {
            this.setTitle(I18n.tr((String)"Conflicts when merging nodes - target node is ''{0}''", (Object[])new Object[]{this.targetPrimitive.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}));
            this.helpAction.setHelpTopic(HelpUtil.ht((String)"/Action/MergeNodes#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht((String)"/Action/MergeNodes#ResolvingConflicts"));
        }
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.updateTitle();
        this.spTagConflictTypes = new AutoAdjustingSplitPane(0);
        this.spTagConflictTypes.setTopComponent(this.buildTagConflictResolverPanel());
        this.spTagConflictTypes.setBottomComponent(this.buildRelationMemberConflictResolverPanel());
        this.pnlButtons = this.buildButtonPanel();
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.addWindowListener(new AdjustDividerLocationAction());
        HelpUtil.setHelpContext((JComponent)this.getRootPane(), (String)HelpUtil.ht((String)"/"));
    }

    protected JPanel buildTagConflictResolverPanel() {
        this.pnlTagConflictResolver = new MyTagConflictResolver();
        return this.pnlTagConflictResolver;
    }

    protected JPanel buildRelationMemberConflictResolverPanel() {
        this.pnlRelationMemberConflictResolver = new MyRelationMemberConflictResolver();
        return this.pnlRelationMemberConflictResolver;
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        ApplyAction applyAction = new ApplyAction();
        this.pnlTagConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.pnlRelationMemberConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.btnApply = new SideButton((Action)applyAction);
        this.btnApply.setFocusable(true);
        pnl.add((Component)this.btnApply);
        CancelAction cancelAction = new CancelAction();
        pnl.add((Component)new SideButton((Action)cancelAction));
        this.helpAction = new ContextSensitiveHelpAction();
        pnl.add((Component)new SideButton((Action)this.helpAction));
        return pnl;
    }

    public MyCombinePrimitiveResolverDialog(Component owner) {
        super((Window)JOptionPane.getFrameForComponent(owner), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public MyTagConflictResolverModel getTagConflictResolverModel() {
        return this.pnlTagConflictResolver.getModel();
    }

    public MyRelationMemberConflictResolverModel getRelationMemberConflictResolverModel() {
        return this.pnlRelationMemberConflictResolver.getModel();
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive primitive, TagCollection tc) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (String key : tc.getKeys()) {
            if (tc.hasUniqueEmptyValue(key)) {
                if (primitive.get(key) == null) continue;
                cmds.add((Command)new ChangePropertyCommand(primitive, key, null));
                continue;
            }
            String value = tc.getJoinedValues(key);
            if (value.equals(primitive.get(key))) continue;
            cmds.add((Command)new ChangePropertyCommand(primitive, key, value));
        }
        return cmds;
    }

    public List<Command> buildWayResolutionCommands() {
        Command cmd;
        LinkedList<Command> cmds = new LinkedList<Command>();
        TagCollection allResolutions = this.getTagConflictResolverModel().getAllResolutions();
        if (allResolutions.size() > 0) {
            cmds.addAll(this.buildTagChangeCommand(this.targetPrimitive, allResolutions));
        }
        if (this.targetPrimitive.get("created_by") != null) {
            cmds.add((Command)new ChangePropertyCommand(this.targetPrimitive, "created_by", null));
        }
        if ((cmd = this.pnlRelationMemberConflictResolver.buildTagApplyCommands(this.getRelationMemberConflictResolverModel().getModifiedRelations(this.targetPrimitive))) != null) {
            cmds.add(cmd);
        }
        return cmds;
    }

    public void buildRelationCorrespondance(Map<Relation, Relation> newRelations, Map<Way, Way> oldWays) {
        this.getRelationMemberConflictResolverModel().buildRelationCorrespondance(this.targetPrimitive, newRelations, oldWays);
    }

    protected void prepareDefaultTagDecisions() {
        MyTagConflictResolverModel model = this.getTagConflictResolverModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            MultiValueResolutionDecision decision = model.getDecision(i);
            List values = decision.getValues();
            values.remove("");
            if (values.size() == 1) {
                decision.keepOne((String)values.get(0));
                continue;
            }
            decision.keepAll();
        }
        model.rebuild();
    }

    protected void prepareDefaultRelationDecisions() {
        MyRelationMemberConflictResolverModel model = this.getRelationMemberConflictResolverModel();
        HashSet<Relation> relations = new HashSet<Relation>();
        for (int i = 0; i < model.getNumDecisions(); ++i) {
            RelationMemberConflictDecision decision = model.getDecision(i);
            if (!relations.contains(decision.getRelation())) {
                decision.decide(RelationMemberConflictDecisionType.KEEP);
                relations.add(decision.getRelation());
                continue;
            }
            decision.decide(RelationMemberConflictDecisionType.REMOVE);
        }
        model.refresh();
    }

    public void prepareDefaultDecisions() {
        this.prepareDefaultTagDecisions();
        this.prepareDefaultRelationDecisions();
    }

    protected JPanel buildEmptyConflictsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add(new JLabel(I18n.tr((String)"No conflicts to resolve", null)));
        return pnl;
    }

    protected void prepareGUIBeforeConflictResolutionStarts() {
        MyRelationMemberConflictResolverModel relModel = this.getRelationMemberConflictResolverModel();
        MyTagConflictResolverModel tagModel = this.getTagConflictResolverModel();
        this.getContentPane().removeAll();
        if (relModel.getNumDecisions() > 0 && tagModel.getNumDecisions() > 0) {
            this.spTagConflictTypes.setTopComponent(this.pnlTagConflictResolver);
            this.spTagConflictTypes.setBottomComponent(this.pnlRelationMemberConflictResolver);
            this.getContentPane().add((Component)this.spTagConflictTypes, "Center");
        } else if (relModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlRelationMemberConflictResolver, "Center");
        } else if (tagModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlTagConflictResolver, "Center");
        } else {
            this.getContentPane().add((Component)this.buildEmptyConflictsPanel(), "Center");
        }
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.validate();
        int numTagDecisions = this.getTagConflictResolverModel().getNumDecisions();
        int numRelationDecisions = this.getRelationMemberConflictResolverModel().getNumDecisions();
        if (numTagDecisions > 0 && numRelationDecisions > 0) {
            this.spTagConflictTypes.setDividerLocation(0.5);
        }
        this.pnlRelationMemberConflictResolver.prepareForEditing();
    }

    protected void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.prepareGUIBeforeConflictResolutionStarts();
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow((Component)Main.parent, (Dimension)new Dimension(600, 400))).applySafe((Window)this);
            this.setCancelled(false);
            this.btnApply.requestFocusInWindow();
        } else {
            new WindowGeometry((Window)this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public class MyTagConflictResolverTable
    extends JTable
    implements MultiValueCellEditor.NavigationListener {
        private SelectNextColumnCellAction selectNextColumnCellAction;
        private SelectPreviousColumnCellAction selectPreviousColumnCellAction;

        public MyTagConflictResolverTable(MyTagConflictResolverModel model) {
            super(model, (TableColumnModel)new TagConflictResolverColumnModel());
            this.build();
        }

        protected void build() {
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
            this.selectNextColumnCellAction = new SelectNextColumnCellAction();
            this.selectPreviousColumnCellAction = new SelectPreviousColumnCellAction();
            this.getActionMap().put("selectNextColumnCell", this.selectNextColumnCellAction);
            this.getActionMap().put("selectPreviousColumnCell", this.selectPreviousColumnCellAction);
            ((MultiValueCellEditor)this.getColumnModel().getColumn(2).getCellEditor()).addNavigationListeners((MultiValueCellEditor.NavigationListener)this);
            this.setRowHeight((int)new JComboBox().getPreferredSize().getHeight());
        }

        public void gotoNextDecision() {
            this.selectNextColumnCellAction.run();
        }

        public void gotoPreviousDecision() {
            this.selectPreviousColumnCellAction.run();
        }

        class SelectPreviousColumnCellAction
        extends AbstractAction {
            SelectPreviousColumnCellAction() {
            }

            public void actionPerformed(ActionEvent e) {
                this.run();
            }

            public void run() {
                int col = MyTagConflictResolverTable.this.getSelectedColumn();
                int row = MyTagConflictResolverTable.this.getSelectedRow();
                if (MyTagConflictResolverTable.this.getCellEditor() != null) {
                    MyTagConflictResolverTable.this.getCellEditor().stopCellEditing();
                }
                if ((col > 0 || row > 0) && row > 0) {
                    col = 2;
                    --row;
                }
                MyTagConflictResolverTable.this.changeSelection(row, col, false, false);
                MyTagConflictResolverTable.this.editCellAt(MyTagConflictResolverTable.this.getSelectedRow(), MyTagConflictResolverTable.this.getSelectedColumn());
                MyTagConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
            }
        }

        class SelectNextColumnCellAction
        extends AbstractAction {
            SelectNextColumnCellAction() {
            }

            public void actionPerformed(ActionEvent e) {
                this.run();
            }

            public void run() {
                int col = MyTagConflictResolverTable.this.getSelectedColumn();
                int row = MyTagConflictResolverTable.this.getSelectedRow();
                if (MyTagConflictResolverTable.this.getCellEditor() != null) {
                    MyTagConflictResolverTable.this.getCellEditor().stopCellEditing();
                }
                if (col == 2 && row < MyTagConflictResolverTable.this.getRowCount() - 1) {
                    ++row;
                } else if (row < MyTagConflictResolverTable.this.getRowCount() - 1) {
                    col = 2;
                    ++row;
                }
                MyTagConflictResolverTable.this.changeSelection(row, col, false, false);
                MyTagConflictResolverTable.this.editCellAt(MyTagConflictResolverTable.this.getSelectedRow(), MyTagConflictResolverTable.this.getSelectedColumn());
                MyTagConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }

    public class MyTagConflictResolver
    extends JPanel {
        private MyTagConflictResolverModel model = new MyTagConflictResolverModel();
        private JCheckBox cbShowTagsWithConflictsOnly;
        private JCheckBox cbShowTagsWithMultiValuesOnly;

        protected JPanel buildInfoPanel() {
            JPanel pnl = new JPanel();
            pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pnl.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 1;
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            gc.anchor = 21;
            pnl.add((Component)new JLabel(I18n.tr((String)"<html>Please select the values to keep for the following tags.</html>", null)), gc);
            gc.gridy = 1;
            gc.fill = 2;
            gc.weighty = 0.0;
            this.cbShowTagsWithConflictsOnly = new JCheckBox(I18n.tr((String)"Show tags with conflicts only", null));
            pnl.add((Component)this.cbShowTagsWithConflictsOnly, gc);
            this.cbShowTagsWithMultiValuesOnly = new JCheckBox(I18n.tr((String)"Show tags with multiple values only", null));
            pnl.add((Component)this.cbShowTagsWithMultiValuesOnly, gc);
            this.cbShowTagsWithConflictsOnly.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MyTagConflictResolver.this.model.setShowTagsWithConflictsOnly(MyTagConflictResolver.this.cbShowTagsWithConflictsOnly.isSelected());
                    MyTagConflictResolver.this.cbShowTagsWithMultiValuesOnly.setEnabled(MyTagConflictResolver.this.cbShowTagsWithConflictsOnly.isSelected());
                }
            });
            this.cbShowTagsWithConflictsOnly.setSelected(Main.pref.getBoolean(this.getClass().getName() + ".showTagsWithConflictsOnly", false));
            this.cbShowTagsWithMultiValuesOnly.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MyTagConflictResolver.this.model.setShowTagsWithMultiValuesOnly(MyTagConflictResolver.this.cbShowTagsWithMultiValuesOnly.isSelected());
                }
            });
            this.cbShowTagsWithMultiValuesOnly.setSelected(Main.pref.getBoolean(this.getClass().getName() + ".showTagsWithMultiValuesOnly", false));
            this.cbShowTagsWithMultiValuesOnly.setEnabled(this.cbShowTagsWithConflictsOnly.isSelected());
            return pnl;
        }

        public void rememberPreferences() {
            Main.pref.put(this.getClass().getName() + ".showTagsWithConflictsOnly", this.cbShowTagsWithConflictsOnly.isSelected());
            Main.pref.put(this.getClass().getName() + ".showTagsWithMultiValuesOnly", this.cbShowTagsWithMultiValuesOnly.isSelected());
        }

        protected void build() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.buildInfoPanel(), "North");
            this.add((Component)new JScrollPane(new MyTagConflictResolverTable(this.model)), "Center");
        }

        public MyTagConflictResolver() {
            this.build();
        }

        public MyTagConflictResolverModel getModel() {
            return this.model;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyTagConflictResolverModel
    extends DefaultTableModel {
        public static final String NUM_CONFLICTS_PROP = MyTagConflictResolverModel.class.getName() + ".numConflicts";
        private TagCollection tags;
        private List<String> displayedKeys;
        private Set<String> keysWithConflicts;
        private HashMap<String, MultiValueResolutionDecision> decisions;
        private int numConflicts = 0;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private boolean showTagsWithConflictsOnly = false;
        private boolean showTagsWithMultiValuesOnly = false;

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        protected void setNumConflicts(int numConflicts) {
            int oldValue = this.numConflicts;
            this.numConflicts = numConflicts;
            if (oldValue != this.numConflicts) {
                this.support.firePropertyChange(NUM_CONFLICTS_PROP, oldValue, this.numConflicts);
            }
        }

        protected void refreshNumConflicts() {
            int count = 0;
            for (MultiValueResolutionDecision d : this.decisions.values()) {
                if (d.isDecided()) continue;
                ++count;
            }
            this.setNumConflicts(count);
        }

        protected void sort() {
            Collections.sort(this.displayedKeys, new Comparator<String>(){

                @Override
                public int compare(String key1, String key2) {
                    if (((MultiValueResolutionDecision)MyTagConflictResolverModel.this.decisions.get(key1)).isDecided() && !((MultiValueResolutionDecision)MyTagConflictResolverModel.this.decisions.get(key2)).isDecided()) {
                        return 1;
                    }
                    if (!((MultiValueResolutionDecision)MyTagConflictResolverModel.this.decisions.get(key1)).isDecided() && ((MultiValueResolutionDecision)MyTagConflictResolverModel.this.decisions.get(key2)).isDecided()) {
                        return -1;
                    }
                    return key1.compareTo(key2);
                }
            });
        }

        protected void rebuild() {
            if (this.tags == null) {
                return;
            }
            for (String key : this.tags.getKeys()) {
                MultiValueResolutionDecision decision = new MultiValueResolutionDecision(this.tags.getTagsFor(key));
                if (this.decisions.get(key) != null) continue;
                this.decisions.put(key, decision);
            }
            this.displayedKeys.clear();
            Set keys = this.tags.getKeys();
            if (this.showTagsWithConflictsOnly) {
                keys.retainAll(this.keysWithConflicts);
                if (this.showTagsWithMultiValuesOnly) {
                    HashSet<String> keysWithMultiValues = new HashSet<String>();
                    for (String key : keys) {
                        if (!this.decisions.get(key).canKeepAll()) continue;
                        keysWithMultiValues.add(key);
                    }
                    keys.retainAll(keysWithMultiValues);
                }
                for (String key : this.tags.getKeys()) {
                    if (this.decisions.get(key).isDecided() || keys.contains(key)) continue;
                    keys.add(key);
                }
            }
            this.displayedKeys.addAll(keys);
            this.refreshNumConflicts();
            this.sort();
            this.fireTableDataChanged();
        }

        public void populate(TagCollection tags, Set<String> keysWithConflicts) {
            CheckParameterUtil.ensureParameterNotNull((Object)tags, (String)"tags");
            this.tags = tags;
            this.displayedKeys = new ArrayList<String>();
            this.keysWithConflicts = keysWithConflicts == null ? new HashSet() : keysWithConflicts;
            this.decisions = new HashMap();
            this.rebuild();
        }

        @Override
        public int getRowCount() {
            if (this.displayedKeys == null) {
                return 0;
            }
            return this.displayedKeys.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.decisions.get(this.displayedKeys.get(row));
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 2;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            MultiValueResolutionDecision decision = this.decisions.get(this.displayedKeys.get(row));
            if (value instanceof String) {
                decision.keepOne((String)value);
            } else if (value instanceof MultiValueDecisionType) {
                MultiValueDecisionType type = (MultiValueDecisionType)value;
                switch (type) {
                    case KEEP_NONE: {
                        decision.keepNone();
                        break;
                    }
                    case KEEP_ALL: {
                        decision.keepAll();
                    }
                }
            }
            this.fireTableDataChanged();
            this.refreshNumConflicts();
        }

        public boolean isResolvedCompletely() {
            return this.numConflicts == 0;
        }

        public int getNumConflicts() {
            return this.numConflicts;
        }

        public int getNumDecisions() {
            return this.getRowCount();
        }

        public TagCollection getResolution() {
            TagCollection tc = new TagCollection();
            for (String key : this.displayedKeys) {
                tc.add(this.decisions.get(key).getResolution());
            }
            return tc;
        }

        public TagCollection getAllResolutions() {
            TagCollection tc = new TagCollection();
            for (MultiValueResolutionDecision value : this.decisions.values()) {
                tc.add(value.getResolution());
            }
            return tc;
        }

        public MultiValueResolutionDecision getDecision(int row) {
            return this.decisions.get(this.displayedKeys.get(row));
        }

        public void setShowTagsWithConflictsOnly(boolean showTagsWithConflictsOnly) {
            this.showTagsWithConflictsOnly = showTagsWithConflictsOnly;
            this.rebuild();
        }

        public void setShowTagsWithMultiValuesOnly(boolean showTagsWithMultiValuesOnly) {
            this.showTagsWithMultiValuesOnly = showTagsWithMultiValuesOnly;
            this.rebuild();
        }

        public void prepareDefaultTagDecisions() {
            for (MultiValueResolutionDecision decision : this.decisions.values()) {
                List values = decision.getValues();
                values.remove("");
                if (values.size() == 1) {
                    decision.keepOne((String)values.get(0));
                    continue;
                }
                decision.keepAll();
            }
            this.rebuild();
        }
    }

    public class MyRelationMemberConflictResolverTable
    extends JTable
    implements MultiValueCellEditor.NavigationListener {
        private SelectNextColumnCellAction selectNextColumnCellAction;
        private SelectPreviousColumnCellAction selectPreviousColumnCellAction;

        public MyRelationMemberConflictResolverTable(MyRelationMemberConflictResolverModel model) {
            super(model, (TableColumnModel)new RelationMemberConflictResolverColumnModel());
            this.build();
        }

        protected void build() {
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
            this.selectNextColumnCellAction = new SelectNextColumnCellAction();
            this.selectPreviousColumnCellAction = new SelectPreviousColumnCellAction();
            this.getActionMap().put("selectNextColumnCell", this.selectNextColumnCellAction);
            this.getActionMap().put("selectPreviousColumnCell", this.selectPreviousColumnCellAction);
            this.setRowHeight((int)new JComboBox().getPreferredSize().getHeight());
        }

        public void gotoNextDecision() {
            this.selectNextColumnCellAction.run();
        }

        public void gotoPreviousDecision() {
            this.selectPreviousColumnCellAction.run();
        }

        class SelectPreviousColumnCellAction
        extends AbstractAction {
            SelectPreviousColumnCellAction() {
            }

            public void actionPerformed(ActionEvent e) {
                this.run();
            }

            public void run() {
                int col = MyRelationMemberConflictResolverTable.this.getSelectedColumn();
                int row = MyRelationMemberConflictResolverTable.this.getSelectedRow();
                if (MyRelationMemberConflictResolverTable.this.getCellEditor() != null) {
                    MyRelationMemberConflictResolverTable.this.getCellEditor().stopCellEditing();
                }
                if ((col > 0 || row > 0) && row > 0) {
                    col = 2;
                    --row;
                }
                MyRelationMemberConflictResolverTable.this.changeSelection(row, col, false, false);
                MyRelationMemberConflictResolverTable.this.editCellAt(MyRelationMemberConflictResolverTable.this.getSelectedRow(), MyRelationMemberConflictResolverTable.this.getSelectedColumn());
                MyRelationMemberConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
            }
        }

        class SelectNextColumnCellAction
        extends AbstractAction {
            SelectNextColumnCellAction() {
            }

            public void actionPerformed(ActionEvent e) {
                this.run();
            }

            public void run() {
                int col = MyRelationMemberConflictResolverTable.this.getSelectedColumn();
                int row = MyRelationMemberConflictResolverTable.this.getSelectedRow();
                if (MyRelationMemberConflictResolverTable.this.getCellEditor() != null) {
                    MyRelationMemberConflictResolverTable.this.getCellEditor().stopCellEditing();
                }
                if (col == 2 && row < MyRelationMemberConflictResolverTable.this.getRowCount() - 1) {
                    ++row;
                } else if (row < MyRelationMemberConflictResolverTable.this.getRowCount() - 1) {
                    col = 2;
                    ++row;
                }
                MyRelationMemberConflictResolverTable.this.changeSelection(row, col, false, false);
                MyRelationMemberConflictResolverTable.this.editCellAt(MyRelationMemberConflictResolverTable.this.getSelectedRow(), MyRelationMemberConflictResolverTable.this.getSelectedColumn());
                MyRelationMemberConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyRelationMemberConflictResolver
    extends JPanel {
        private AutoCompletingTextField tfRole;
        private AutoCompletingTextField tfKey;
        private AutoCompletingTextField tfValue;
        private JCheckBox cbTagRelations;
        private MyRelationMemberConflictResolverModel model;
        private MyRelationMemberConflictResolverTable tblResolver;
        private JMultilineLabel lblHeader;

        protected void build() {
            this.setLayout(new GridBagLayout());
            JPanel pnl = new JPanel();
            pnl.setLayout(new BorderLayout());
            this.lblHeader = new JMultilineLabel("");
            pnl.add((Component)this.lblHeader);
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)pnl, gc);
            this.model = new MyRelationMemberConflictResolverModel();
            gc.gridy = 1;
            gc.weighty = 1.0;
            gc.fill = 1;
            gc.insets = new Insets(0, 0, 0, 0);
            this.tblResolver = new MyRelationMemberConflictResolverTable(this.model);
            this.add((Component)new JScrollPane(this.tblResolver), gc);
            pnl = new JPanel();
            pnl.setLayout(new BoxLayout(pnl, 1));
            pnl.add(this.buildRoleEditingPanel());
            pnl.add(this.buildTagRelationsPanel());
            gc.gridy = 2;
            gc.weighty = 0.0;
            gc.fill = 2;
            this.add((Component)pnl, gc);
        }

        protected JPanel buildRoleEditingPanel() {
            JPanel pnl = new JPanel();
            pnl.setLayout(new FlowLayout(0));
            pnl.add(new JLabel(I18n.tr((String)"Role:", null)));
            this.tfRole = new AutoCompletingTextField(10);
            pnl.add((Component)this.tfRole);
            this.tfRole.setToolTipText(I18n.tr((String)"Enter a role for all relation memberships", null));
            pnl.add(new JButton(new ApplyRoleAction()));
            this.tfRole.addActionListener((ActionListener)new ApplyRoleAction());
            this.tfRole.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    MyRelationMemberConflictResolver.this.tfRole.selectAll();
                }
            });
            return pnl;
        }

        protected JPanel buildTagRelationsPanel() {
            JPanel pnl = new JPanel();
            pnl.setLayout(new FlowLayout(0));
            this.cbTagRelations = new JCheckBox(I18n.tr((String)"Tag modified relations with ", null));
            this.cbTagRelations.addChangeListener(new ToggleTagRelationsAction());
            this.cbTagRelations.setToolTipText(I18n.tr((String)"<html>Select to enable entering a tag which will be applied<br>to all modified relations.</html>", null));
            pnl.add(this.cbTagRelations);
            pnl.add(new JLabel(I18n.trc((String)"tag", (String)"Key:")));
            this.tfKey = new AutoCompletingTextField(10);
            pnl.add((Component)this.tfKey);
            this.tfKey.setToolTipText(I18n.tr((String)"<html>Enter a tag key, i.e. <strong><tt>fixme</tt></strong></html>", null));
            pnl.add(new JLabel(I18n.tr((String)"Value:", null)));
            this.tfValue = new AutoCompletingTextField(10);
            pnl.add((Component)this.tfValue);
            this.tfValue.setToolTipText(I18n.tr((String)"<html>Enter a tag value, i.e. <strong><tt>check members</tt></strong></html>", null));
            this.cbTagRelations.setSelected(false);
            this.tfKey.setEnabled(false);
            this.tfValue.setEnabled(false);
            return pnl;
        }

        public MyRelationMemberConflictResolver() {
            this.build();
        }

        public void initForWayCombining() {
            this.lblHeader.setText(I18n.tr((String)"<html>The combined ways are members in one ore more relations. Please decide whether you want to <strong>keep</strong> these memberships for the combined way or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first way and <strong>remove</strong> the other ways that are members of the same relation: the combined way will take the place of the original way in the relation.</html>", null));
            this.invalidate();
        }

        public void initForNodeMerging() {
            this.lblHeader.setText(I18n.tr((String)"<html>The merged nodes are members in one ore more relations. Please decide whether you want to <strong>keep</strong> these memberships for the target node or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first node and <strong>remove</strong> the other nodes that are members of the same relation: the target node will take the place of the original node in the relation.</html>", null));
            this.invalidate();
        }

        public MyRelationMemberConflictResolverModel getModel() {
            return this.model;
        }

        public Command buildTagApplyCommands(Collection<? extends OsmPrimitive> primitives) {
            if (!this.cbTagRelations.isSelected()) {
                return null;
            }
            if (this.tfKey.getText().trim().equals("")) {
                return null;
            }
            if (this.tfValue.getText().trim().equals("")) {
                return null;
            }
            if (primitives == null || primitives.isEmpty()) {
                return null;
            }
            return new ChangePropertyCommand(primitives, this.tfKey.getText(), this.tfValue.getText());
        }

        public void prepareForEditing() {
            AutoCompletionList acList = new AutoCompletionList();
            Main.main.getEditLayer().data.getAutoCompletionManager().populateWithMemberRoles(acList);
            this.tfRole.setAutoCompletionList(acList);
            AutoCompletingTextField editor = (AutoCompletingTextField)this.tblResolver.getColumnModel().getColumn(2).getCellEditor();
            if (editor != null) {
                editor.setAutoCompletionList(acList);
            }
            AutoCompletionList acList2 = new AutoCompletionList();
            Main.main.getEditLayer().data.getAutoCompletionManager().populateWithKeys(acList2);
            this.tfKey.setAutoCompletionList(acList2);
        }

        class ToggleTagRelationsAction
        implements ChangeListener {
            ToggleTagRelationsAction() {
            }

            public void stateChanged(ChangeEvent e) {
                ButtonModel buttonModel = ((AbstractButton)e.getSource()).getModel();
                MyRelationMemberConflictResolver.this.tfKey.setEnabled(buttonModel.isSelected());
                MyRelationMemberConflictResolver.this.tfValue.setEnabled(buttonModel.isSelected());
                MyRelationMemberConflictResolver.this.tfKey.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
                MyRelationMemberConflictResolver.this.tfValue.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
            }
        }

        class ApplyRoleAction
        extends AbstractAction {
            public ApplyRoleAction() {
                this.putValue("Name", I18n.tr((String)"Apply", null));
                this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
                this.putValue("ShortDescription", I18n.tr((String)"Apply this role to all members", null));
            }

            public void actionPerformed(ActionEvent e) {
                MyRelationMemberConflictResolver.this.model.applyRole(MyRelationMemberConflictResolver.this.tfRole.getText());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyRelationMemberConflictResolverModel
    extends DefaultTableModel {
        public static final String NUM_CONFLICTS_PROP = MyRelationMemberConflictResolverModel.class.getName() + ".numConflicts";
        private List<RelationMemberConflictDecision> decisions = new ArrayList<RelationMemberConflictDecision>();
        private Collection<Relation> relations;
        private int numConflicts;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public int getNumConflicts() {
            return this.numConflicts;
        }

        protected void updateNumConflicts() {
            int count = 0;
            for (RelationMemberConflictDecision decision : this.decisions) {
                if (decision.isDecided()) continue;
                ++count;
            }
            int oldValue = this.numConflicts;
            this.numConflicts = count;
            if (this.numConflicts != oldValue) {
                this.support.firePropertyChange(NUM_CONFLICTS_PROP, oldValue, this.numConflicts);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }

        @Override
        public int getRowCount() {
            if (this.decisions == null) {
                return 0;
            }
            return this.decisions.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.decisions == null) {
                return null;
            }
            RelationMemberConflictDecision d = this.decisions.get(row);
            switch (column) {
                case 0: {
                    return d.getRelation();
                }
                case 1: {
                    return Integer.toString(d.getPos() + 1);
                }
                case 2: {
                    return d.getRole();
                }
                case 3: {
                    return d.getOriginalPrimitive();
                }
                case 4: {
                    return d.getDecision();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            RelationMemberConflictDecision d = this.decisions.get(row);
            switch (column) {
                case 2: {
                    d.setRole((String)value);
                    break;
                }
                case 4: {
                    d.decide((RelationMemberConflictDecisionType)value);
                    this.refresh();
                }
            }
            this.fireTableDataChanged();
        }

        protected void populate(Relation relation, OsmPrimitive primitive, Map<Way, Way> oldWays) {
            for (int i = 0; i < relation.getMembersCount(); ++i) {
                if (MergeOverlapAction.getOld(relation.getMember(i).getWay(), oldWays) != MergeOverlapAction.getOld((Way)primitive, oldWays)) continue;
                this.decisions.add(new RelationMemberConflictDecision(relation, i));
            }
        }

        public void populate(Collection<Relation> relations, Collection<? extends OsmPrimitive> memberPrimitives, Map<Way, Way> oldWays) {
            this.decisions.clear();
            relations = relations == null ? new LinkedList<Relation>() : relations;
            memberPrimitives = memberPrimitives == null ? new LinkedList() : memberPrimitives;
            for (Relation r : relations) {
                for (OsmPrimitive p : memberPrimitives) {
                    this.populate(r, p, oldWays);
                }
            }
            this.relations = relations;
            this.refresh();
        }

        public void populate(Collection<RelationToChildReference> references) {
            references = references == null ? new LinkedList() : references;
            this.decisions.clear();
            this.relations = new HashSet<Relation>(references.size());
            for (RelationToChildReference reference : references) {
                this.decisions.add(new RelationMemberConflictDecision(reference.getParent(), reference.getPosition()));
                this.relations.add(reference.getParent());
            }
            this.refresh();
        }

        public RelationMemberConflictDecision getDecision(int row) {
            return this.decisions.get(row);
        }

        public int getNumDecisions() {
            return this.getRowCount();
        }

        public void refresh() {
            this.updateNumConflicts();
            this.fireTableDataChanged();
        }

        public void applyRole(String role) {
            role = role == null ? "" : role;
            for (RelationMemberConflictDecision decision : this.decisions) {
                decision.setRole(role);
            }
            this.refresh();
        }

        protected RelationMemberConflictDecision getDecision(Relation relation, int pos) {
            for (RelationMemberConflictDecision decision : this.decisions) {
                if (!decision.matches(relation, pos)) continue;
                return decision;
            }
            return null;
        }

        protected void buildResolveCorrespondance(Relation relation, OsmPrimitive newPrimitive, Map<Relation, Relation> newRelations, Map<Way, Way> oldWays) {
            List relationsMembers = relation.getMembers();
            Relation modifiedRelation = MergeOverlapAction.getNew(relation, newRelations);
            modifiedRelation.setMembers(null);
            block4: for (int i = 0; i < relationsMembers.size(); ++i) {
                RelationMember rm = (RelationMember)relationsMembers.get(i);
                RelationMemberConflictDecision decision = this.getDecision(relation, i);
                if (decision == null) {
                    modifiedRelation.addMember(rm);
                    continue;
                }
                System.out.println(modifiedRelation);
                System.out.println(111);
                switch (decision.getDecision()) {
                    case KEEP: {
                        System.out.println(222);
                        if (newPrimitive instanceof Way) {
                            modifiedRelation.addMember(new RelationMember(decision.getRole(), (OsmPrimitive)MergeOverlapAction.getOld((Way)newPrimitive, oldWays)));
                            continue block4;
                        }
                        modifiedRelation.addMember(new RelationMember(decision.getRole(), newPrimitive));
                        continue block4;
                    }
                    case REMOVE: {
                        System.out.println(333);
                        continue block4;
                    }
                }
            }
        }

        public void buildRelationCorrespondance(OsmPrimitive newPrimitive, Map<Relation, Relation> newRelations, Map<Way, Way> oldWays) {
            for (Relation relation : this.relations) {
                this.buildResolveCorrespondance(relation, newPrimitive, newRelations, oldWays);
            }
        }

        protected boolean isChanged(Relation relation, OsmPrimitive newPrimitive) {
            block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
                RelationMemberConflictDecision decision = this.getDecision(relation, i);
                if (decision == null) continue;
                switch (decision.getDecision()) {
                    case REMOVE: {
                        return true;
                    }
                    case KEEP: {
                        if (!relation.getMember(i).getRole().equals(decision.getRole())) {
                            return true;
                        }
                        if (relation.getMember(i).getMember() == newPrimitive) continue block4;
                        return true;
                    }
                }
            }
            return false;
        }

        public Set<Relation> getModifiedRelations(OsmPrimitive newPrimitive) {
            HashSet<Relation> ret = new HashSet<Relation>();
            for (Relation relation : this.relations) {
                if (!this.isChanged(relation, newPrimitive)) continue;
                ret.add(relation);
            }
            return ret;
        }
    }

    static class AutoAdjustingSplitPane
    extends JSplitPane
    implements PropertyChangeListener,
    HierarchyBoundsListener {
        private double dividerLocation;

        public AutoAdjustingSplitPane(int newOrientation) {
            super(newOrientation);
            this.addPropertyChangeListener("dividerLocation", this);
            this.addHierarchyBoundsListener(this);
        }

        public void ancestorResized(HierarchyEvent e) {
            this.setDividerLocation((int)(this.dividerLocation * (double)this.getHeight()));
        }

        public void ancestorMoved(HierarchyEvent e) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dividerLocation")) {
                int newVal = (Integer)evt.getNewValue();
                if (this.getHeight() != 0) {
                    this.dividerLocation = (double)newVal / (double)this.getHeight();
                }
            }
        }
    }

    class AdjustDividerLocationAction
    extends WindowAdapter {
        AdjustDividerLocationAction() {
        }

        public void windowOpened(WindowEvent e) {
            int numTagDecisions = MyCombinePrimitiveResolverDialog.this.getTagConflictResolverModel().getNumDecisions();
            int numRelationDecisions = MyCombinePrimitiveResolverDialog.this.getRelationMemberConflictResolverModel().getNumDecisions();
            if (numTagDecisions > 0 && numRelationDecisions > 0) {
                MyCombinePrimitiveResolverDialog.this.spTagConflictTypes.setDividerLocation(0.5);
            }
        }
    }

    class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Apply resolved conflicts", null));
            this.putValue("Name", I18n.tr((String)"Apply", null));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent arg0) {
            MyCombinePrimitiveResolverDialog.this.setVisible(false);
            MyCombinePrimitiveResolverDialog.this.pnlTagConflictResolver.rememberPreferences();
        }

        protected void updateEnabledState() {
            this.setEnabled(MyCombinePrimitiveResolverDialog.this.pnlTagConflictResolver.getModel().getNumConflicts() == 0 && MyCombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.getModel().getNumConflicts() == 0);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(MyTagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
            if (evt.getPropertyName().equals(MyRelationMemberConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Cancel conflict resolution", null));
            this.putValue("Name", I18n.tr((String)"Cancel", null));
            this.putValue("SmallIcon", ImageProvider.get((String)"", (String)"cancel"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            MyCombinePrimitiveResolverDialog.this.setCancelled(true);
            MyCombinePrimitiveResolverDialog.this.setVisible(false);
        }
    }
}

