/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectBoundaryAction
extends JosmAction {
    private Way lastUsedStartingWay;
    private boolean lastUsedLeft;

    public SelectBoundaryAction() {
        super(I18n.tr((String)"Area boundary [testing]", (Object[])new Object[0]), "selboundary", I18n.tr((String)"Select relation or all ways that forms area boundary", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selboundary", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Area boundary [testing]"}), (int)47, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectAreaBoundary"));
    }

    public void actionPerformed(ActionEvent e) {
        long t = System.currentTimeMillis();
        LinkedHashSet selectedWays = OsmPrimitive.getFilteredSet((Collection)SelectBoundaryAction.getCurrentDataSet().getSelected(), Way.class);
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)SelectBoundaryAction.getCurrentDataSet().getSelected(), Node.class);
        LinkedHashSet selectedRelations = OsmPrimitive.getFilteredSet((Collection)SelectBoundaryAction.getCurrentDataSet().getSelected(), Relation.class);
        HashSet<Way> newWays = new HashSet<Way>();
        Way w = null;
        Relation selectedRelation = null;
        if (selectedRelations.size() == 1) {
            selectedRelation = (Relation)selectedRelations.iterator().next();
            if (selectedRelation.getMemberPrimitives().contains(this.lastUsedStartingWay)) {
                w = this.lastUsedStartingWay;
            }
        } else if (selectedWays.isEmpty()) {
            if (selectedNodes.size() == 1) {
                for (OsmPrimitive p : ((Node)selectedNodes.iterator().next()).getReferrers()) {
                    if (!(p instanceof Way) || !p.isSelectable()) continue;
                    w = (Way)p;
                    break;
                }
            }
        } else if (selectedWays.size() == 1) {
            w = (Way)selectedWays.iterator().next();
        } else if (selectedWays.contains(this.lastUsedStartingWay)) {
            w = this.lastUsedStartingWay;
            boolean bl = this.lastUsedLeft = !this.lastUsedLeft;
        }
        if (w == null) {
            return;
        }
        if (!w.isSelectable()) {
            return;
        }
        if (w.isClosed()) {
            return;
        }
        if (w.getNodesCount() < 2) {
            return;
        }
        newWays.add(w);
        this.lastUsedStartingWay = w;
        ArrayList<Relation> rels = new ArrayList<Relation>();
        for (OsmPrimitive p : w.getReferrers()) {
            if (!(p instanceof Relation) || !p.isSelectable()) continue;
            rels.add((Relation)p);
        }
        if (selectedRelation != null) {
            int idx = rels.indexOf(selectedRelation);
            if (idx >= 0) {
                if (idx + 1 < rels.size()) {
                    SelectBoundaryAction.getCurrentDataSet().setSelected(Arrays.asList((Relation)rels.get(idx + 1)));
                } else {
                    SelectBoundaryAction.getCurrentDataSet().setSelected(Arrays.asList((Relation)rels.get(0)));
                }
                return;
            }
        } else if (rels.size() > 0) {
            SelectBoundaryAction.getCurrentDataSet().setSelected(Arrays.asList((Relation)rels.get(0)));
            return;
        }
        if (!NodeWayUtils.addAreaBoundary(w, newWays, this.lastUsedLeft)) {
            NodeWayUtils.addAreaBoundary(w, newWays, !this.lastUsedLeft);
        }
        if (!newWays.isEmpty()) {
            SelectBoundaryAction.getCurrentDataSet().setSelected(newWays);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Nothing found. Please select way that is a part of some polygon formed by connected ways", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
        }
    }

    protected void updateEnabledState() {
        if (SelectBoundaryAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SelectBoundaryAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

