/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.Component;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.extensions.jfcunit.finder.JMenuItemFinder;

public class PathData {
    private int[] m_indexes;
    private String[] m_path;

    public PathData(int size) {
        this.m_path = new String[size];
        this.m_indexes = new int[size];
    }

    public PathData(String[] path) {
        this(path, null);
    }

    public PathData(String[] path, int[] indexes) {
        this.m_path = path;
        if (indexes == null) {
            this.m_indexes = new int[path.length];
            Arrays.fill(this.m_indexes, 0);
        } else {
            this.m_indexes = indexes;
        }
        if (this.m_indexes.length != path.length) {
            throw new IllegalArgumentException("Index length does not match string length");
        }
    }

    public PathData(JMenuItem mi) {
        Vector<String> strings = new Vector<String>();
        strings.insertElementAt(mi.getText(), 0);
        Component parent = ((JPopupMenu)mi.getParent()).getInvoker();
        while (parent instanceof JMenuItem) {
            String text = ((JMenuItem)parent).getText();
            strings.insertElementAt(text, 0);
            if (parent instanceof JPopupMenu) {
                parent = ((JPopupMenu)parent.getParent()).getInvoker();
                continue;
            }
            if (!(parent instanceof JMenu) || !((parent = ((JMenu)parent).getParent()) instanceof JPopupMenu)) continue;
            parent = ((JPopupMenu)parent).getInvoker();
        }
        this.m_path = strings.toArray(new String[0]);
        this.m_indexes = new int[this.m_path.length];
        Arrays.fill(this.m_indexes, 0);
    }

    public Object getRoot(JMenuItem mi) {
        JMenuItem lastParent = null;
        Component parent = mi;
        while (parent instanceof JMenuItem) {
            lastParent = parent;
            if (!((parent = parent.getParent()) instanceof JPopupMenu)) continue;
            lastParent = parent;
            parent = ((JPopupMenu)parent).getInvoker();
        }
        if (parent instanceof JMenuBar) {
            return parent;
        }
        return lastParent;
    }

    public final void set(int i, String data, int index) {
        this.m_path[i] = data;
        this.m_indexes[i] = index;
    }

    public int[] getIndexes(JComponent menu) {
        int[] result = new int[this.m_path.length];
        int i = 0;
        JComponent parent = menu;
        JMenuItemFinder mFinder = new JMenuItemFinder(this.m_path[i]);
        mFinder.setWait(0);
        Component c = mFinder.find(menu, this.m_indexes[i]);
        if (menu instanceof JMenuBar) {
            result[i++] = ((JMenuBar)menu).getComponentIndex(c);
        } else if (menu instanceof JPopupMenu) {
            result[i++] = ((JPopupMenu)menu).getComponentIndex(c);
        }
        while (i < this.m_path.length) {
            if (c instanceof JMenu) {
                JMenu m = (JMenu)c;
                mFinder = new JMenuItemFinder(this.m_path[i]);
                JPopupMenu pm = m.getPopupMenu();
                c = mFinder.find(pm, this.m_indexes[i]);
                Component[] comps = pm.getComponents();
                result[i] = -1;
                for (int j = 0; j < comps.length && result[i] == -1; ++j) {
                    if (comps[j] != c) continue;
                    result[i] = j;
                }
            }
            ++i;
        }
        return result;
    }

    public TreePath getTreePath(JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Tree cannot be null");
        }
        if (this.m_path.length == 0) {
            return null;
        }
        TreeModel model = tree.getModel();
        Object node = model.getRoot();
        Vector<Object> path = new Vector<Object>();
        for (int i = 0; i < this.m_path.length; ++i) {
            int children;
            String text = this.m_path[i];
            int idx = this.m_indexes[i];
            boolean found = false;
            boolean root = false;
            if (i == 0) {
                root = true;
                children = 1;
            } else {
                children = model.getChildCount(node);
            }
            for (int j = 0; j < children && !found; ++j) {
                Object newnode = root ? node : model.getChild(node, j);
                if (!text.equals(newnode.toString())) continue;
                if (idx == 0) {
                    node = newnode;
                    path.add(node);
                    found = true;
                    continue;
                }
                --idx;
            }
            if (found) continue;
            return null;
        }
        TreePath tp = new TreePath(path.toArray());
        return tp;
    }
}

