/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import java.awt.Component;
import java.awt.Container;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class ParentInstanceTagHandler
extends AbstractTagHandler {
    public ParentInstanceTagHandler(Element element, IXMLTestCase testcase) {
        super(element, testcase);
    }

    public void processElement() throws XMLException {
        Class<?> cls;
        this.validateElement();
        String refid = this.getString("refid");
        String id = this.getString("id");
        String classname = this.getString("classname");
        Object o = this.getXMLTestCase().getProperty(refid);
        if (!(o instanceof Component)) {
            throw new XMLException("object not a component:" + o, null, this.getElement(), this.getXMLTestCase().getPropertyCache());
        }
        try {
            cls = Class.forName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new XMLException("Cannot find class:" + classname, (Throwable)ex, this.getElement(), this.getXMLTestCase().getPropertyCache());
        }
        for (Container comp = ((Component)o).getParent(); comp != null; comp = comp.getParent()) {
            if (!cls.isAssignableFrom(comp.getClass())) continue;
            this.getXMLTestCase().addProperty(id, comp);
            return;
        }
        this.getXMLTestCase().addProperty(id, null);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("id");
        this.checkRequiredAttribute("refid");
        this.checkRequiredAttribute("classname");
    }
}

