/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import java.io.File;
import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.XMLUtil;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class FileTagHandler
extends AbstractTagHandler {
    public FileTagHandler(Element element, IXMLTestSuite testSuite) {
        super(element, testSuite);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        String name = this.getString("name");
        if (this.getBoolean("relative")) {
            Element curdoc = this.getElement().getOwnerDocument().getDocumentElement();
            String location = curdoc.getAttribute("JFCFileLocation");
            int index = location.lastIndexOf(File.separator);
            name = location.substring(0, index + 1) + name;
        }
        try {
            Element doc = XMLUtil.parse(XMLUtil.readFileFromClasspath(name)).getDocumentElement();
            doc.setAttribute("JFCFileLocation", name);
            String tag = doc.getTagName();
            XMLTagResourceBundle.getTagHandler(doc, this.getTest(), tag).processElement();
        }
        catch (OutOfMemoryError err) {
            throw new XMLException("Out of memory check for recursive file includes.", (Throwable)err, this.getElement(), this.getXMLTestSuite().getPropertyCache());
        }
        catch (XMLException xe) {
            throw xe;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), (Throwable)e, this.getElement(), this.getTest().getPropertyCache());
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("name");
    }
}

