/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.finder;

import junit.extensions.jfcunit.finder.BaseFindTagHandler;
import junit.extensions.jfcunit.finder.NamedComponentFinder;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import org.w3c.dom.Element;

public class NamedComponentFinderTagHandler
extends BaseFindTagHandler {
    public NamedComponentFinderTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        String name = this.getName();
        String clazzName = this.getClassName();
        boolean caseIndependent = this.getCaseIndependent();
        try {
            Class<?> clazz = Class.forName(clazzName);
            this.find(new NamedComponentFinder(clazz, name, caseIndependent));
        }
        catch (ClassNotFoundException ex) {
            throw new XMLException("Could not find class:" + clazzName, (Throwable)ex, this.getElement(), this.getXMLTestCase().getPropertyCache());
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("name");
        this.checkRequiredAttribute("class");
    }
}

