/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class Wagner2Projection
extends Projection {
    private static final double C_x = 0.92483;
    private static final double C_y = 1.38725;
    private static final double C_p1 = 0.88022;
    private static final double C_p2 = 0.8855;

    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.y = ProjectionMath.asin(0.88022 * Math.sin(0.8855 * lpphi));
        out.x = 0.92483 * lplam * Math.cos(lpphi);
        out.y = 1.38725 * lpphi;
        return out;
    }

    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = xyy / 1.38725;
        out.x = xyx / (0.92483 * Math.cos(out.y));
        out.y = ProjectionMath.asin(Math.sin(out.y) / 0.88022) / 0.8855;
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Wagner II";
    }
}

