/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.resources.LazySet;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.logging.Logging;

public final class Converters {
    private static final Logger LOGGER = Logging.getLogger(Converters.class);
    static ConverterFactory[] factories;
    private static FactoryRegistry registry;

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(Converters.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(ConverterFactory.class));
        }
        return registry;
    }

    private static Hints addDefaultHints(Hints hints) {
        Hints hints2 = GeoTools.getDefaultHints();
        if (hints != null) {
            hints2.add(hints);
        }
        return hints2;
    }

    public static synchronized Set getConverterFactories(Hints hints) {
        hints = Converters.addDefaultHints(hints);
        return new LazySet<ConverterFactory>(Converters.getServiceRegistry().getServiceProviders(ConverterFactory.class, null, hints));
    }

    public static <T> T convert(Object object, Class<T> clazz) {
        return Converters.convert(object, clazz, null);
    }

    public static <T> T convert(Object object, Class<T> clazz, Hints hints) {
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz2 == clazz || clazz2.equals(clazz) || clazz.isAssignableFrom(clazz2)) {
            return (T)object;
        }
        for (ConverterFactory converterFactory : Converters.factories()) {
            Converter converter = converterFactory.createConverter(clazz2, clazz, hints);
            if (converter == null) continue;
            try {
                T t = converter.convert(object, clazz);
                if (t == null) continue;
                return t;
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Error applying the converter " + converter.getClass() + " on (" + object + "," + clazz + ")", exception);
            }
        }
        if (String.class.equals(clazz)) {
            return (T)object.toString();
        }
        return null;
    }

    static ConverterFactory[] factories() {
        if (factories == null) {
            Set set = Converters.getConverterFactories(GeoTools.getDefaultHints());
            factories = set.toArray(new ConverterFactory[set.size()]);
        }
        return factories;
    }
}

