/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.HashMap;
import java.util.Map;
import org.geotools.metadata.PropertyAccessor;
import org.geotools.metadata.PropertyMap;
import org.geotools.metadata.PropertyTree;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.resources.i18n.Errors;

public final class MetadataStandard {
    public static final MetadataStandard ISO_19115 = new MetadataStandard("org.opengis.metadata.");
    private final String interfacePackage;
    private final Map<Class<?>, PropertyAccessor> accessors = new HashMap();
    private final ThreadLocal<PropertyTree> treeBuilders = new ThreadLocal<PropertyTree>(){

        @Override
        protected PropertyTree initialValue() {
            return new PropertyTree(MetadataStandard.this);
        }
    };

    public MetadataStandard(String string) {
        if (!string.endsWith(".")) {
            string = string + '.';
        }
        this.interfacePackage = string;
    }

    private PropertyAccessor getAccessor(Class<?> clazz) throws ClassCastException {
        PropertyAccessor propertyAccessor = this.getAccessorOptional(clazz);
        if (propertyAccessor == null) {
            throw new ClassCastException(Errors.format(187, clazz.getName()));
        }
        return propertyAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PropertyAccessor getAccessorOptional(Class<?> clazz) {
        Map<Class<?>, PropertyAccessor> map = this.accessors;
        synchronized (map) {
            Class<?> clazz2;
            PropertyAccessor propertyAccessor = this.accessors.get(clazz);
            if (propertyAccessor == null && (clazz2 = this.getType(clazz)) != null) {
                propertyAccessor = new PropertyAccessor(clazz, clazz2);
                this.accessors.put(clazz, propertyAccessor);
            }
            return propertyAccessor;
        }
    }

    private Class<?> getType(Class<?> clazz) {
        return PropertyAccessor.getType(clazz, this.interfacePackage);
    }

    public Class<?> getInterface(Class<?> clazz) throws ClassCastException {
        return this.getAccessor(clazz).type;
    }

    public Map<String, Object> asMap(Object object) throws ClassCastException {
        return new PropertyMap(object, this.getAccessor(object.getClass()));
    }

    final boolean isModifiable(Class clazz) throws ClassCastException {
        return this.getAccessor(clazz).isModifiable();
    }

    final void freeze(Object object) throws ClassCastException {
        this.getAccessor(object.getClass()).freeze(object);
    }

    public void shallowCopy(Object object, Object object2, boolean bl) throws ClassCastException, UnmodifiableMetadataException {
        MetadataStandard.ensureNonNull("target", object2);
        PropertyAccessor propertyAccessor = this.getAccessor(object2.getClass());
        if (!propertyAccessor.type.isInstance(object)) {
            MetadataStandard.ensureNonNull("source", object);
            throw new ClassCastException(Errors.format(61, object.getClass(), propertyAccessor.type));
        }
        if (!propertyAccessor.shallowCopy(object, object2, bl)) {
            throw new UnmodifiableMetadataException(Errors.format(190));
        }
    }

    public boolean shallowEquals(Object object, Object object2, boolean bl) throws ClassCastException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        PropertyAccessor propertyAccessor = this.getAccessor(object.getClass());
        if (!propertyAccessor.type.equals(this.getType(object2.getClass()))) {
            return false;
        }
        return propertyAccessor.shallowEquals(object, object2, bl);
    }

    public int hashCode(Object object) throws ClassCastException {
        return this.getAccessor(object.getClass()).hashCode(object);
    }

    public String toString(Object object) throws ClassCastException {
        PropertyTree propertyTree = this.treeBuilders.get();
        return PropertyTree.toString(propertyTree.asTree(object));
    }

    private static void ensureNonNull(String string, Object object) {
        if (object == null) {
            throw new NullPointerException(Errors.format(143, string));
        }
    }
}

