/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import org.geotools.geometry.AbstractDirectPosition;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractEnvelope
implements Envelope {
    protected AbstractEnvelope() {
    }

    static CoordinateReferenceSystem getCoordinateReferenceSystem(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        CoordinateReferenceSystem coordinateReferenceSystem2 = directPosition2.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            return coordinateReferenceSystem2;
        }
        if (coordinateReferenceSystem2 != null && !coordinateReferenceSystem.equals(coordinateReferenceSystem2)) {
            throw new MismatchedReferenceSystemException(Errors.format(92));
        }
        return coordinateReferenceSystem;
    }

    public DirectPosition getLowerCorner() {
        return new LowerCorner();
    }

    public DirectPosition getUpperCorner() {
        return new UpperCorner();
    }

    public String toString() {
        return AbstractEnvelope.toString(this);
    }

    static String toString(Envelope envelope) {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(envelope));
        int n = envelope.getDimension();
        if (n != 0) {
            int n2;
            String string = "[(";
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append(string).append(envelope.getMinimum(n2));
                string = ", ";
            }
            string = "), (";
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append(string).append(envelope.getMaximum(n2));
                string = ", ";
            }
            stringBuilder.append(")]");
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = this.getDimension();
        int n2 = 1;
        boolean bl = true;
        do {
            for (int i = 0; i < n; ++i) {
                long l = Double.doubleToLongBits(bl ? this.getMinimum(i) : this.getMaximum(i));
                n2 = 31 * n2 + ((int)l ^ (int)(l >>> 32));
            }
        } while (!(bl = !bl));
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            n2 += coordinateReferenceSystem.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Envelope envelope = (Envelope)object;
            int n = this.getDimension();
            if (n == envelope.getDimension()) {
                for (int i = 0; i < n; ++i) {
                    if (Utilities.equals(this.getMinimum(i), envelope.getMinimum(i)) && Utilities.equals(this.getMaximum(i), envelope.getMaximum(i))) continue;
                    return false;
                }
                if (Utilities.equals(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == envelope.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }

    private final class UpperCorner
    extends Corner {
        private UpperCorner() {
        }

        @Override
        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getMaximum(n);
        }
    }

    private final class LowerCorner
    extends Corner {
        private LowerCorner() {
        }

        @Override
        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getMinimum(n);
        }
    }

    private abstract class Corner
    extends AbstractDirectPosition {
        private Corner() {
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return AbstractEnvelope.this.getCoordinateReferenceSystem();
        }

        @Override
        public int getDimension() {
            return AbstractEnvelope.this.getDimension();
        }

        @Override
        public void setOrdinate(int n, double d) {
            throw new UnsupportedOperationException();
        }
    }
}

