/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import com.vividsolutions.jts.geom.Geometry;
import java.util.regex.Pattern;
import org.geotools.factory.Hints;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class SimpleFeaturePropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor ATTRIBUTE_ACCESS = new SimpleFeaturePropertyAccessor();
    static PropertyAccessor DEFAULT_GEOMETRY_ACCESS = new DefaultGeometrySimpleFeaturePropertyAccessor();
    static PropertyAccessor FID_ACCESS = new FidSimpleFeaturePropertyAccessor();
    static Pattern idPattern = Pattern.compile("@(\\w+:)?id");
    static Pattern propertyPattern = Pattern.compile("(\\w+:)?(\\w+)");

    @Override
    public PropertyAccessor createPropertyAccessor(Class clazz, String string, Class clazz2, Hints hints) {
        if (string == null) {
            return null;
        }
        if (!SimpleFeature.class.isAssignableFrom(clazz) && !SimpleFeatureType.class.isAssignableFrom(clazz)) {
            return null;
        }
        if ("".equals(string)) {
            return DEFAULT_GEOMETRY_ACCESS;
        }
        if (idPattern.matcher(string).matches()) {
            return FID_ACCESS;
        }
        if (propertyPattern.matcher(string).matches()) {
            return ATTRIBUTE_ACCESS;
        }
        return null;
    }

    static String stripPrefix(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    static class SimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        SimpleFeaturePropertyAccessor() {
        }

        @Override
        public boolean canHandle(Object object, String string, Class clazz) {
            string = SimpleFeaturePropertyAccessorFactory.stripPrefix(string);
            if (object instanceof SimpleFeature) {
                return ((SimpleFeature)object).getType().getDescriptor(string) != null;
            }
            if (object instanceof SimpleFeatureType) {
                return ((SimpleFeatureType)object).getDescriptor(string) != null;
            }
            return false;
        }

        @Override
        public Object get(Object object, String string, Class clazz) {
            string = SimpleFeaturePropertyAccessorFactory.stripPrefix(string);
            if (object instanceof SimpleFeature) {
                return ((SimpleFeature)object).getAttribute(string);
            }
            if (object instanceof SimpleFeatureType) {
                return ((SimpleFeatureType)object).getDescriptor(string);
            }
            return null;
        }
    }

    static class DefaultGeometrySimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        DefaultGeometrySimpleFeaturePropertyAccessor() {
        }

        @Override
        public boolean canHandle(Object object, String string, Class clazz) {
            if (!"".equals(string)) {
                return false;
            }
            return object instanceof SimpleFeature || object instanceof SimpleFeatureType;
        }

        @Override
        public Object get(Object object, String string, Class clazz) {
            if (object instanceof SimpleFeature) {
                SimpleFeature simpleFeature = (SimpleFeature)object;
                Object object2 = simpleFeature.getDefaultGeometry();
                if (object2 == null) {
                    for (Object object3 : simpleFeature.getAttributes()) {
                        if (!(object3 instanceof Geometry)) continue;
                        object2 = object3;
                        break;
                    }
                }
                return object2;
            }
            if (object instanceof SimpleFeatureType) {
                SimpleFeatureType simpleFeatureType = (SimpleFeatureType)object;
                GeometryDescriptor geometryDescriptor = simpleFeatureType.getGeometryDescriptor();
                if (geometryDescriptor == null) {
                    for (AttributeDescriptor attributeDescriptor : simpleFeatureType.getAttributeDescriptors()) {
                        if (!Geometry.class.isAssignableFrom(attributeDescriptor.getType().getBinding())) continue;
                        return attributeDescriptor;
                    }
                }
                return geometryDescriptor;
            }
            return null;
        }
    }

    static class FidSimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        FidSimpleFeaturePropertyAccessor() {
        }

        @Override
        public boolean canHandle(Object object, String string, Class clazz) {
            return object instanceof SimpleFeature && string.matches("@(\\w+:)?id");
        }

        @Override
        public Object get(Object object, String string, Class clazz) {
            SimpleFeature simpleFeature = (SimpleFeature)object;
            return simpleFeature.getID();
        }
    }
}

