/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.resources.NIOUtilities;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;

class MemoryMapCache {
    static final Logger LOGGER = Logging.getLogger(MemoryMapCache.class);
    SoftValueHashMap<MappingKey, MappedByteBuffer> buffers = new SoftValueHashMap(0);

    MemoryMapCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MappedByteBuffer map(FileChannel fileChannel, URL uRL, FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        if (mapMode != FileChannel.MapMode.READ_ONLY) {
            return fileChannel.map(mapMode, l, l2);
        }
        File file = DataUtilities.urlToFile(uRL).getCanonicalFile();
        MappingKey mappingKey = new MappingKey(file, l, l2);
        MappedByteBuffer mappedByteBuffer = this.buffers.get(mappingKey);
        if (mappedByteBuffer == null) {
            MemoryMapCache memoryMapCache = this;
            synchronized (memoryMapCache) {
                mappedByteBuffer = this.buffers.get(mappingKey);
                if (mappedByteBuffer == null) {
                    mappedByteBuffer = fileChannel.map(mapMode, l, l2);
                    this.buffers.put(mappingKey, mappedByteBuffer);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Mapping and caching " + file.getAbsolutePath());
                    }
                }
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Using cached map for " + file.getAbsolutePath());
        }
        return (MappedByteBuffer)mappedByteBuffer.duplicate();
    }

    void clean() {
        ArrayList arrayList = new ArrayList(this.buffers.keySet());
        for (MappingKey mappingKey : arrayList) {
            MappedByteBuffer mappedByteBuffer = this.buffers.remove(mappingKey);
            NIOUtilities.clean(mappedByteBuffer, true);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Removed mapping for " + mappingKey.file.getAbsolutePath());
        }
    }

    static class MappingKey {
        File file;
        long position;
        long size;

        public MappingKey(File file, long l, long l2) {
            this.file = file;
            this.position = l;
            this.size = l2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.file == null ? 0 : this.file.hashCode());
            n = 31 * n + (int)(this.position ^ this.position >>> 32);
            n = 31 * n + (int)(this.size ^ this.size >>> 32);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MappingKey mappingKey = (MappingKey)object;
            if (this.file == null ? mappingKey.file != null : !this.file.equals(mappingKey.file)) {
                return false;
            }
            if (this.position != mappingKey.position) {
                return false;
            }
            return this.size == mappingKey.size;
        }
    }
}

