/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core;

import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.projection.BelgianLambert1972;
import org.openstreetmap.josm.data.projection.BelgianLambert2008;
import org.openstreetmap.josm.data.projection.Epsg4326;
import org.openstreetmap.josm.data.projection.Lambert93;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.opendata.core.io.LambertCC9ZonesProjectionPatterns;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionPatterns;
import org.openstreetmap.josm.tools.I18n;

public interface OdConstants {
    public static final String UTF8 = "UTF-8";
    public static final String ISO8859_15 = "ISO-8859-15";
    public static final String CP850 = "Cp850";
    public static final String CP1252 = "Cp1252";
    public static final String MAC_ROMAN = "MacRoman";
    public static final String PATTERN_LANG = "{lang}";
    public static final String PREF_OAPI = "opendata.oapi";
    public static final String DEFAULT_OAPI = "http://www.overpass-api.de/api/interpreter?";
    public static final String PREF_XAPI = "opendata.xapi";
    public static final String DEFAULT_XAPI = "http://www.overpass-api.de/api/xapi?";
    public static final String PREF_RAWDATA = "opendata.rawdata";
    public static final boolean DEFAULT_RAWDATA = false;
    public static final String PREF_MAXDISTANCE = "opendata.maxdistance";
    public static final double DEFAULT_MAXDISTANCE = 10.0;
    public static final String PREF_MODULES = "opendata.modules";
    public static final String PREF_MODULES_SITES = "opendata.modules.sites";
    public static final String GOOGLE_SITE = "http://josm-toulouse-data.googlecode.com/svn/trunk/";
    public static final String OSM_SITE = "http://svn.openstreetmap.org/applications/editors/josm/plugins/opendata/";
    public static final String[] DEFAULT_MODULE_SITES = new String[]{"http://svn.openstreetmap.org/applications/editors/josm/plugins/opendata/modules.txt%<?modules=>"};
    public static final String PREF_CRS_COMPARISON_TOLERANCE = "opendata.crs.comparison_tolerance";
    public static final Double DEFAULT_CRS_COMPARISON_TOLERANCE = 1.0E-8;
    public static final String PREF_CRS_COMPARISON_DEBUG = "opendata.crs.comparison_debug";
    public static final String ICON_CORE_16 = "o16.png";
    public static final String ICON_CORE_24 = "o24.png";
    public static final String ICON_CORE_48 = "o48.png";
    public static final String ICON_OSM_16 = "osm16.png";
    public static final String ICON_OSM_24 = "osm24.png";
    public static final String ICON_AGREEMENT_24 = "agreement24.png";
    public static final String ICON_EMPTY_24 = "empty24.png";
    public static final String ICON_LOOL_48 = "lool48.png";
    public static final String CSV_EXT = "csv";
    public static final String KML_EXT = "kml";
    public static final String KMZ_EXT = "kmz";
    public static final String GML_EXT = "gml";
    public static final String XLS_EXT = "xls";
    public static final String ODS_EXT = "ods";
    public static final String SHP_EXT = "shp";
    public static final String MIF_EXT = "mif";
    public static final String TAB_EXT = "tab";
    public static final String MAPCSS_EXT = "mapcss";
    public static final String ZIP_EXT = "zip";
    public static final String JAR_EXT = "jar";
    public static final String XML_EXT = "xml";
    public static final String PROTO_FILE = "file://";
    public static final String PROTO_RSRC = "resource://";
    public static final ExtensionFileFilter CSV_FILE_FILTER = new ExtensionFileFilter("csv", "csv", I18n.tr((String)"CSV files", (Object[])new Object[0]) + " (*." + "csv" + ")");
    public static final ExtensionFileFilter XLS_FILE_FILTER = new ExtensionFileFilter("xls", "xls", I18n.tr((String)"XLS files", (Object[])new Object[0]) + " (*." + "xls" + ")");
    public static final ExtensionFileFilter ODS_FILE_FILTER = new ExtensionFileFilter("ods", "ods", I18n.tr((String)"ODS files", (Object[])new Object[0]) + " (*." + "ods" + ")");
    public static final ExtensionFileFilter SHP_FILE_FILTER = new ExtensionFileFilter("shp", "shp", I18n.tr((String)"Shapefiles", (Object[])new Object[0]) + " (*." + "shp" + ")");
    public static final ExtensionFileFilter MIF_TAB_FILE_FILTER = new ExtensionFileFilter("mif,tab", "mif", I18n.tr((String)"MapInfo files", (Object[])new Object[0]) + " (*." + "mif" + ",*." + "tab" + ")");
    public static final ExtensionFileFilter KML_KMZ_FILE_FILTER = new ExtensionFileFilter("kml,kmz", "kmz", I18n.tr((String)"KML/KMZ files", (Object[])new Object[0]) + " (*." + "kml" + ",*." + "kmz" + ")");
    public static final ExtensionFileFilter GML_FILE_FILTER = new ExtensionFileFilter("gml", "gml", I18n.tr((String)"GML files", (Object[])new Object[0]) + " (*." + "gml" + ")");
    public static final ExtensionFileFilter ZIP_FILE_FILTER = new ExtensionFileFilter("zip", "zip", I18n.tr((String)"Zip Files", (Object[])new Object[0]) + " (*." + "zip" + ")");
    public static final ExtensionFileFilter XML_FILE_FILTER = new ExtensionFileFilter("xml", "xml", I18n.tr((String)"OpenData XML files", (Object[])new Object[0]) + " (*." + "xml" + ")");
    public static final String X_STRING = "X|LON|LONGI|LONGITUDE.*|EASTING";
    public static final String Y_STRING = "Y|LAT|LATI|LATITUDE.*|NORTHING";
    public static final Collection<ProjectionPatterns> PROJECTIONS = new ArrayList<ProjectionPatterns>();
    public static final ProjectionPatterns PRJ_UNKNOWN = new ProjectionPatterns("");
    public static final ProjectionPatterns PRJ_WGS84 = new ProjectionPatterns("GPS|WGS84|\u00b0d\u00e9cimaux", (Projection)new Epsg4326());
    public static final ProjectionPatterns PRJ_LAMBERT_93 = new ProjectionPatterns("LAMB93|L93", (Projection)new Lambert93());
    public static final ProjectionPatterns PRJ_LAMBERT_CC_9_ZONES = new LambertCC9ZonesProjectionPatterns("LAMBZ|CC(42|43|44|45|46|47|48|49|50)");
    public static final ProjectionPatterns PRJ_LAMBERT_1972 = new ProjectionPatterns("LAMB72|LAMB1972", (Projection)new BelgianLambert1972());
    public static final ProjectionPatterns PRJ_LAMBERT_2008 = new ProjectionPatterns("LAMB08|LAMB2008", (Projection)new BelgianLambert2008());
    public static final String RESOURCE_PATH = "/org/openstreetmap/josm/plugins/opendata/core/resources/";
    public static final String DICTIONARY_FR = "/org/openstreetmap/josm/plugins/opendata/core/resources/dictionary.fr.csv";
}

