/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.Utilities;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

public abstract class GenericName
implements org.opengis.util.GenericName,
Serializable {
    private static final long serialVersionUID = 8685047583179337259L;
    public static final char DEFAULT_SEPARATOR = ':';
    private transient NameSpace namespace;

    protected GenericName() {
    }

    static CharSequence validate(CharSequence charSequence) {
        return charSequence == null || charSequence instanceof InternationalString ? charSequence : ((Object)charSequence).toString();
    }

    @Override
    public NameSpace scope() {
        if (this.namespace == null) {
            this.namespace = new NameSpace(){

                @Override
                public org.opengis.util.GenericName name() {
                    return GenericName.this.getScope();
                }
            };
        }
        return this.namespace;
    }

    @Deprecated
    public abstract org.opengis.util.GenericName getScope();

    @Override
    public int depth() {
        return this.getParsedNames().size();
    }

    public abstract List<LocalName> getParsedNames();

    @Override
    public LocalName head() {
        List<LocalName> list = this.getParsedNames();
        return list.get(0);
    }

    @Override
    public LocalName tip() {
        List<LocalName> list = this.getParsedNames();
        return list.get(list.size() - 1);
    }

    @Deprecated
    public LocalName name() {
        return this.tip();
    }

    @Deprecated
    public abstract ScopedName asScopedName();

    char getSeparator() {
        return ':';
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        List<LocalName> list = this.getParsedNames();
        char c = this.getSeparator();
        Iterator<LocalName> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }

    @Override
    public InternationalString toInternationalString() {
        return new International(this.getParsedNames(), this.getSeparator());
    }

    @Override
    public int compareTo(org.opengis.util.GenericName genericName) {
        Iterator<LocalName> iterator = this.getParsedNames().iterator();
        Iterator<? extends LocalName> iterator2 = genericName.getParsedNames().iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return 1;
            }
            LocalName localName = iterator.next();
            LocalName localName2 = iterator2.next();
            if (localName == this && localName2 == genericName) {
                throw new IllegalStateException();
            }
            int n = localName.compareTo(localName2);
            if (n == 0) continue;
            return n;
        }
        return iterator2.hasNext() ? -1 : 0;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GenericName genericName = (GenericName)object;
            return Utilities.equals(this.getParsedNames(), genericName.getParsedNames()) && this.getSeparator() == genericName.getSeparator();
        }
        return false;
    }

    public int hashCode() {
        return 0xF4C4EE2B ^ ((Object)this.getParsedNames()).hashCode();
    }

    private static final class International
    extends AbstractInternationalString
    implements Serializable {
        private static final long serialVersionUID = -4234089612436334148L;
        private final List<? extends LocalName> parsedNames;
        private final char separator;

        public International(List<? extends LocalName> list, char c) {
            this.parsedNames = list;
            this.separator = c;
        }

        @Override
        public String toString(Locale locale) {
            StringBuilder stringBuilder = new StringBuilder();
            for (LocalName localName : this.parsedNames) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(this.separator);
                }
                stringBuilder.append(localName.toInternationalString().toString(locale));
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                International international = (International)object;
                return Utilities.equals(this.parsedNames, international.parsedNames) && this.separator == international.separator;
            }
            return false;
        }

        public int hashCode() {
            return 0x3F8F99BC ^ ((Object)this.parsedNames).hashCode();
        }
    }
}

