/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Classes;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;

public class IndexedResourceBundle
extends ResourceBundle {
    private static final int MAX_STRING_LENGTH = 200;
    private final String filename = this.getClass().getSimpleName() + ".utf";
    private String[] values;
    private transient Locale locale;
    private transient MessageFormat format;
    private transient int lastKey;

    protected IndexedResourceBundle() {
    }

    private Locale getFormatLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
            Locale locale = this.getLocale();
            if (!this.locale.getLanguage().equalsIgnoreCase(locale.getLanguage())) {
                this.locale = locale;
            }
        }
        return this.locale;
    }

    private String getPackageName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(0, n) : "org.geotools";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] ensureLoaded(String string) throws MissingResourceException {
        LogRecord logRecord = null;
        try {
            String[] stringArray;
            Object object = this;
            synchronized (object) {
                int n;
                InputStream inputStream;
                stringArray = this.values;
                if (stringArray != null) {
                    return stringArray;
                }
                logRecord = new LogRecord(Level.FINER, "Loaded resources for {0} from bundle \"{1}\".");
                logRecord.setSourceClassName(this.getClass().getName());
                logRecord.setSourceMethodName(string != null ? "getObject" : "getKeys");
                String string2 = this.filename;
                while ((inputStream = this.getClass().getResourceAsStream(string2)) == null) {
                    int n2 = string2.lastIndexOf(46);
                    n = string2.lastIndexOf(95, n2 - 1);
                    if (n <= 0) {
                        throw new FileNotFoundException(this.filename);
                    }
                    string2 = string2.substring(0, n) + string2.substring(n2);
                }
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                stringArray = new String[dataInputStream.readInt()];
                this.values = stringArray;
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = dataInputStream.readUTF();
                    if (stringArray[n].length() != 0) continue;
                    stringArray[n] = null;
                }
                dataInputStream.close();
                String string3 = this.getLocale().getDisplayName(Locale.US);
                if (string3 == null || string3.length() == 0) {
                    string3 = "<default>";
                }
                logRecord.setParameters(new String[]{string3, this.getPackageName()});
            }
            object = Logging.getLogger(IndexedResourceBundle.class);
            logRecord.setLoggerName(((Logger)object).getName());
            ((Logger)object).log(logRecord);
            return stringArray;
        }
        catch (IOException iOException) {
            logRecord.setLevel(Level.WARNING);
            logRecord.setMessage(iOException.getLocalizedMessage());
            logRecord.setThrown(iOException);
            Logger logger = Logging.getLogger(IndexedResourceBundle.class);
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
            MissingResourceException missingResourceException = new MissingResourceException(iOException.getLocalizedMessage(), this.getClass().getName(), string);
            missingResourceException.initCause(iOException);
            throw missingResourceException;
        }
    }

    @Override
    public final Enumeration<String> getKeys() {
        final String[] stringArray = this.ensureLoaded(null);
        return new Enumeration<String>(){
            private int i = 0;

            @Override
            public boolean hasMoreElements() {
                while (this.i < stringArray.length) {
                    if (stringArray[this.i] != null) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            @Override
            public String nextElement() {
                while (true) {
                    if (this.i >= stringArray.length) {
                        throw new NoSuchElementException();
                    }
                    if (stringArray[this.i] != null) {
                        return String.valueOf(this.i++);
                    }
                    ++this.i;
                }
            }
        };
    }

    @Override
    protected final Object handleGetObject(String string) {
        int n;
        String[] stringArray = this.ensureLoaded(string);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return n >= 0 && n < stringArray.length ? stringArray[n] : null;
    }

    private static String summarize(String string, int n) {
        int n2;
        int n3 = (string = string.trim()).length();
        if (n3 <= n) {
            return string;
        }
        if ((n = n - 7 >> 1) <= 0) {
            return string;
        }
        int n4 = n3 - n;
        int n5 = n >> 1;
        for (n2 = n; n2 >= n5; --n2) {
            if (Character.isUnicodeIdentifierPart(string.charAt(n2))) continue;
            while (--n2 >= n5 && !Character.isUnicodeIdentifierPart(string.charAt(n2))) {
            }
            break;
        }
        n5 = n3 - (n >> 1);
        while (n4 < n5) {
            if (!Character.isUnicodeIdentifierPart(string.charAt(n4))) {
                while (++n4 < n5 && !Character.isUnicodeIdentifierPart(string.charAt(n4))) {
                }
                break;
            }
            ++n4;
        }
        return (string.substring(0, n2 + 1) + " (...) " + string.substring(n4)).trim();
    }

    private Object[] toArray(Object object) {
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            Object object2 = objectArray[i];
            if (object2 instanceof CharSequence) {
                String string2;
                string = object2 instanceof InternationalString ? ((InternationalString)object2).toString(this.getFormatLocale()) : object2.toString();
                if (string == (string2 = IndexedResourceBundle.summarize(string, 200)) || string.equals(string2)) continue;
                if (objectArray == object) {
                    objectArray = new Object[objectArray.length];
                    System.arraycopy(object, 0, objectArray, 0, objectArray.length);
                }
                objectArray[i] = string2;
                continue;
            }
            if (object2 instanceof Throwable) {
                string = ((Throwable)object2).getLocalizedMessage();
                if (string == null) {
                    string = Classes.getShortClassName(object2);
                }
                objectArray[i] = string;
                continue;
            }
            if (!(object2 instanceof Class)) continue;
            objectArray[i] = Classes.getShortName((Class)object2);
        }
        return objectArray;
    }

    public final String getString(int n) throws MissingResourceException {
        return this.getString(String.valueOf(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(int n, Object object) throws MissingResourceException {
        String string = this.getString(n);
        Object[] objectArray = this.toArray(object);
        IndexedResourceBundle indexedResourceBundle = this;
        synchronized (indexedResourceBundle) {
            if (this.format == null) {
                this.format = new MessageFormat(string, this.getFormatLocale());
            } else if (n != this.lastKey) {
                this.format.applyPattern(string);
                this.lastKey = n;
            }
            return this.format.format(objectArray);
        }
    }

    public final String getString(int n, Object object, Object object2) throws MissingResourceException {
        return this.getString(n, new Object[]{object, object2});
    }

    public final String getString(int n, Object object, Object object2, Object object3) throws MissingResourceException {
        return this.getString(n, new Object[]{object, object2, object3});
    }

    public final String getString(int n, Object object, Object object2, Object object3, Object object4) throws MissingResourceException {
        return this.getString(n, new Object[]{object, object2, object3, object4});
    }

    public LogRecord getLogRecord(Level level, int n) {
        return this.getLogRecord(level, n, null);
    }

    public LogRecord getLogRecord(Level level, int n, Object object) {
        LogRecord logRecord = new LogRecord(level, String.valueOf(n));
        logRecord.setResourceBundle(this);
        if (object != null) {
            logRecord.setParameters(this.toArray(object));
        }
        return logRecord;
    }

    public LogRecord getLogRecord(Level level, int n, Object object, Object object2) {
        return this.getLogRecord(level, n, new Object[]{object, object2});
    }

    public LogRecord getLogRecord(Level level, int n, Object object, Object object2, Object object3) {
        return this.getLogRecord(level, n, new Object[]{object, object2, object3});
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(this));
        stringBuilder.append('[');
        if (this.values != null) {
            int n = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                ++n;
            }
            stringBuilder.append(n);
            stringBuilder.append(" values");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

