/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.Matrix4;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.opengis.referencing.operation.Matrix;

public final class MatrixFactory {
    private MatrixFactory() {
    }

    public static XMatrix create(int n) {
        switch (n) {
            case 1: {
                return new Matrix1();
            }
            case 2: {
                return new Matrix2();
            }
            case 3: {
                return new Matrix3();
            }
            case 4: {
                return new Matrix4();
            }
        }
        return new GeneralMatrix(n);
    }

    public static XMatrix create(int n, int n2) {
        if (n == n2) {
            return MatrixFactory.create(n);
        }
        return new GeneralMatrix(n, n2);
    }

    public static XMatrix create(Matrix matrix) {
        int n = matrix.getNumRow();
        if (n == matrix.getNumCol()) {
            switch (n) {
                case 1: {
                    return new Matrix1(matrix);
                }
                case 2: {
                    return new Matrix2(matrix);
                }
                case 3: {
                    return new Matrix3(matrix);
                }
                case 4: {
                    return new Matrix4(matrix);
                }
            }
        }
        return new GeneralMatrix(matrix);
    }
}

