/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Collection;
import java.util.Date;
import org.geotools.metadata.iso.IdentifierImpl;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

public class CitationImpl
extends MetadataEntity
implements Citation {
    private static final long serialVersionUID = -4415559967618358778L;
    private InternationalString title;
    private Collection<InternationalString> alternateTitles;
    private Collection<CitationDate> dates;
    private InternationalString edition;
    private long editionDate = Long.MIN_VALUE;
    private Collection<Identifier> identifiers;
    private Collection<ResponsibleParty> citedResponsibleParties;
    private Collection<PresentationForm> presentationForm;
    private Series series;
    private InternationalString otherCitationDetails;
    private InternationalString collectiveTitle;
    private String ISBN;
    private String ISSN;

    public CitationImpl() {
    }

    public CitationImpl(Citation citation) {
        super(citation);
    }

    public CitationImpl(CharSequence charSequence) {
        InternationalString internationalString = charSequence instanceof InternationalString ? (InternationalString)charSequence : new SimpleInternationalString(((Object)charSequence).toString());
        this.setTitle(internationalString);
    }

    public CitationImpl(ResponsibleParty responsibleParty) {
        String string;
        InternationalString internationalString = responsibleParty.getOrganisationName();
        if (internationalString == null && (internationalString = responsibleParty.getPositionName()) == null && (string = responsibleParty.getIndividualName()) != null) {
            internationalString = new SimpleInternationalString(string);
        }
        this.setTitle(internationalString);
        this.getCitedResponsibleParties().add(responsibleParty);
    }

    final void addAuthority(String string, boolean bl) {
        if (bl) {
            this.getAlternateTitles().add(new SimpleInternationalString(string));
        }
        this.getIdentifiers().add(new IdentifierImpl(string));
    }

    @Override
    public InternationalString getTitle() {
        return this.title;
    }

    public synchronized void setTitle(InternationalString internationalString) {
        this.checkWritePermission();
        this.title = internationalString;
    }

    public synchronized Collection<InternationalString> getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return this.alternateTitles;
    }

    public synchronized void setAlternateTitles(Collection<? extends InternationalString> collection) {
        this.alternateTitles = this.copyCollection(collection, this.alternateTitles, InternationalString.class);
    }

    public synchronized Collection<CitationDate> getDates() {
        this.dates = this.nonNullCollection(this.dates, CitationDate.class);
        return this.dates;
    }

    public synchronized void setDates(Collection<? extends CitationDate> collection) {
        this.dates = this.copyCollection(collection, this.dates, CitationDate.class);
    }

    public InternationalString getEdition() {
        return this.edition;
    }

    public synchronized void setEdition(InternationalString internationalString) {
        this.checkWritePermission();
        this.edition = internationalString;
    }

    public synchronized Date getEditionDate() {
        return this.editionDate != Long.MIN_VALUE ? new Date(this.editionDate) : null;
    }

    public synchronized void setEditionDate(Date date) {
        this.checkWritePermission();
        this.editionDate = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    public synchronized Collection<Identifier> getIdentifiers() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        return this.identifiers;
    }

    public synchronized void setIdentifiers(Collection<? extends Identifier> collection) {
        this.identifiers = this.copyCollection(collection, this.identifiers, Identifier.class);
    }

    public synchronized Collection<ResponsibleParty> getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return this.citedResponsibleParties;
    }

    public synchronized void setCitedResponsibleParties(Collection<? extends ResponsibleParty> collection) {
        this.citedResponsibleParties = this.copyCollection(collection, this.citedResponsibleParties, ResponsibleParty.class);
    }

    @Override
    public synchronized Collection<PresentationForm> getPresentationForm() {
        this.presentationForm = this.nonNullCollection(this.presentationForm, PresentationForm.class);
        return this.presentationForm;
    }

    public synchronized void setPresentationForm(Collection<? extends PresentationForm> collection) {
        this.presentationForm = this.copyCollection(collection, this.presentationForm, PresentationForm.class);
    }

    public Series getSeries() {
        return this.series;
    }

    public synchronized void setSeries(Series series) {
        this.checkWritePermission();
        this.series = series;
    }

    public InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public synchronized void setOtherCitationDetails(InternationalString internationalString) {
        this.checkWritePermission();
        this.otherCitationDetails = internationalString;
    }

    public InternationalString getCollectiveTitle() {
        return this.collectiveTitle;
    }

    public synchronized void setCollectiveTitle(InternationalString internationalString) {
        this.checkWritePermission();
        this.collectiveTitle = internationalString;
    }

    public String getISBN() {
        return this.ISBN;
    }

    public synchronized void setISBN(String string) {
        this.checkWritePermission();
        this.ISBN = string;
    }

    public String getISSN() {
        return this.ISSN;
    }

    public synchronized void setISSN(String string) {
        this.checkWritePermission();
        this.ISSN = string;
    }
}

