/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import org.geotools.feature.AttributeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Utilities;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.identity.Identifier;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryAttributeImpl
extends AttributeImpl
implements GeometryAttribute {
    protected BoundingBox bounds;

    public GeometryAttributeImpl(Object object, GeometryDescriptor geometryDescriptor, Identifier identifier) {
        super(object, geometryDescriptor, identifier);
    }

    @Override
    public GeometryType getType() {
        return (GeometryType)super.getType();
    }

    @Override
    public GeometryDescriptor getDescriptor() {
        return (GeometryDescriptor)super.getDescriptor();
    }

    public Geometry getValue() {
        return (Geometry)super.getValue();
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException, IllegalStateException {
        this.setValue((Geometry)object);
    }

    public void setValue(Geometry geometry) {
        super.setValue(geometry);
    }

    @Override
    public synchronized BoundingBox getBounds() {
        if (this.bounds == null) {
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(this.getType().getCoordinateReferenceSystem());
            Geometry geometry = this.getValue();
            if (geometry != null) {
                referencedEnvelope.expandToInclude(geometry.getEnvelopeInternal());
            } else {
                referencedEnvelope.setToNull();
            }
            this.bounds = referencedEnvelope;
        }
        return this.bounds;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeometryAttributeImpl)) {
            return false;
        }
        GeometryAttributeImpl geometryAttributeImpl = (GeometryAttributeImpl)object;
        if (!Utilities.equals(this.descriptor, geometryAttributeImpl.descriptor)) {
            return false;
        }
        if (!Utilities.equals(this.id, geometryAttributeImpl.id)) {
            return false;
        }
        if (this.value != null && geometryAttributeImpl.value != null) {
            if (geometryAttributeImpl.value instanceof GeometryCollection && !(geometryAttributeImpl.value instanceof MultiPoint) && !(geometryAttributeImpl.value instanceof MultiLineString) && !(geometryAttributeImpl.value instanceof MultiPolygon)) {
                if (this.value instanceof GeometryCollection) {
                    GeometryCollection geometryCollection = (GeometryCollection)this.value;
                    GeometryCollection geometryCollection2 = (GeometryCollection)geometryAttributeImpl.value;
                    if (geometryCollection.getNumGeometries() != geometryCollection2.getNumGeometries()) {
                        return false;
                    }
                    for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                        Geometry geometry;
                        Geometry geometry2 = geometryCollection.getGeometryN(i);
                        if (geometry2.equals(geometry = geometryCollection2.getGeometryN(i))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return ((Geometry)this.value).equals((Geometry)geometryAttributeImpl.value);
        }
        return Utilities.deepEquals(this.value, this.value);
    }

    @Override
    public int hashCode() {
        int n = this.descriptor.hashCode();
        if (this.id != null) {
            n += 37 * ((Object)this.id).hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getSimpleName()).append(":");
        stringBuffer.append(this.getDescriptor().getName().getLocalPart());
        CoordinateReferenceSystem coordinateReferenceSystem = this.getDescriptor().getType().getCoordinateReferenceSystem();
        if (!this.getDescriptor().getName().getLocalPart().equals(this.getDescriptor().getType().getName().getLocalPart()) || this.id != null || coordinateReferenceSystem != null) {
            stringBuffer.append("<");
            stringBuffer.append(this.getDescriptor().getType().getName().getLocalPart());
            if (this.id != null) {
                stringBuffer.append(" id=");
                stringBuffer.append(this.id);
            }
            if (coordinateReferenceSystem != null) {
                stringBuffer.append(" crs=");
                stringBuffer.append(coordinateReferenceSystem);
            }
            if (this.id != null) {
                stringBuffer.append(" id=");
                stringBuffer.append(this.id);
            }
            stringBuffer.append(">");
        }
        stringBuffer.append("=");
        stringBuffer.append(this.value);
        return stringBuffer.toString();
    }
}

